/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.util;

import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Operation;
import de.justsoftware.mobile.gateway.exception.ForbiddenException;
import de.justsoftware.mobile.gateway.exception.GraphQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0004\u001a*\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0014*\u00020\u0006H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0014*\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001a\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0019"}, d2={"ERROR_CODE_NOT_ALLOWED", "", "ERROR_TYPE_PERMISSION_DENIED", "KEY_ERROR_CODE", "KEY_ERROR_TYPE", "errorCode", "Lcom/apollographql/apollo3/api/Error;", "getErrorCode", "(Lcom/apollographql/apollo3/api/Error;)Ljava/lang/String;", "errorType", "getErrorType", "handleErrors", "", "T", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/api/ApolloResponse;", "logger", "Lorg/slf4j/Logger;", "operationName", "hasNotAllowed", "", "", "hasPermissionDenied", "isNotAllowed", "isPermissionDenied", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nErrors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Errors.kt\nde/justsoftware/mobile/gateway/util/ErrorsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1855#2,2:49\n1747#2,3:51\n1747#2,3:54\n*S KotlinDebug\n*F\n+ 1 Errors.kt\nde/justsoftware/mobile/gateway/util/ErrorsKt\n*L\n21#1:49,2\n37#1:51,3\n38#1:54,3\n*E\n"})
public final class ErrorsKt {
    @NotNull
    private static final String KEY_ERROR_TYPE = "errorType";
    @NotNull
    private static final String KEY_ERROR_CODE = "code";
    @NotNull
    private static final String ERROR_TYPE_PERMISSION_DENIED = "PERMISSION_DENIED";
    @NotNull
    private static final String ERROR_CODE_NOT_ALLOWED = "NOT_ALLOWED";

    public static final <T extends Operation.Data> void handleErrors(@NotNull ApolloResponse<T> $this$handleErrors, @NotNull Logger logger, @NotNull String operationName) {
        Intrinsics.checkNotNullParameter($this$handleErrors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        List list = $this$handleErrors.errors;
        if (list == null) {
            return;
        }
        List errors = list;
        Iterable $this$forEach$iv = errors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Error error = (Error)element$iv;
            boolean bl = false;
            logger.error("Error while executing GraphQL-Query " + operationName + ": " + error);
        }
        if (ErrorsKt.hasPermissionDenied((List)errors) || ErrorsKt.hasNotAllowed((List)errors)) {
            throw new ForbiddenException("User is not authorized to execute GraphQL-Query " + operationName + ".");
        }
        throw new GraphQLException("Error(s) occurred executing GraphQL-Query. See server log for details.");
    }

    private static final boolean hasPermissionDenied(List<Error> $this$hasPermissionDenied) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasPermissionDenied;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error error = (Error)element$iv;
                    boolean bl2 = false;
                    if (!ErrorsKt.isPermissionDenied((Error)error)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasNotAllowed(List<Error> $this$hasNotAllowed) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasNotAllowed;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error error = (Error)element$iv;
                    boolean bl2 = false;
                    if (!ErrorsKt.isNotAllowed((Error)error)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isPermissionDenied(Error $this$isPermissionDenied) {
        return Intrinsics.areEqual((Object)ErrorsKt.getErrorType((Error)$this$isPermissionDenied), (Object)"PERMISSION_DENIED");
    }

    private static final boolean isNotAllowed(Error $this$isNotAllowed) {
        return Intrinsics.areEqual((Object)ErrorsKt.getErrorCode((Error)$this$isNotAllowed), (Object)"NOT_ALLOWED");
    }

    private static final String getErrorType(Error $this$errorType) {
        Map map = $this$errorType.getExtensions();
        Object v = map != null ? map.get("errorType") : null;
        return v instanceof String ? (String)v : null;
    }

    private static final String getErrorCode(Error $this$errorCode) {
        Map map = $this$errorCode.getExtensions();
        Object v = map != null ? map.get("code") : null;
        return v instanceof String ? (String)v : null;
    }
}

