/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Configuration(value="mobileGatewayConfiguration")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0012J\u001a\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0012\u00a8\u0006\f"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/ApiGatewayConfiguration;", "", "()V", "acceptLanguage", "Lorg/springframework/web/reactive/function/client/ExchangeFilterFunction;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "apiWebClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "maxInMemorySize", "", "authFilter", "mobile-gateway"})
public class ApiGatewayConfiguration {
    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @NotNull
    public WebClient apiWebClient(@Value(value="${spring.codec.max-in-memory-size}") int maxInMemorySize, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        WebClient webClient = WebClient.builder().exchangeStrategies(ExchangeStrategies.builder().codecs(arg_0 -> ApiGatewayConfiguration.apiWebClient$lambda$0(maxInMemorySize, arg_0)).build()).filter(this.authFilter(request)).filter(this.acceptLanguage(request)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    private ExchangeFilterFunction authFilter(HttpServletRequest request) {
        return (arg_0, arg_1) -> ApiGatewayConfiguration.authFilter$lambda$1(request, arg_0, arg_1);
    }

    private ExchangeFilterFunction acceptLanguage(HttpServletRequest request) {
        return (arg_0, arg_1) -> ApiGatewayConfiguration.acceptLanguage$lambda$2(request, arg_0, arg_1);
    }

    private static final void apiWebClient$lambda$0(int $maxInMemorySize, ClientCodecConfigurer it) {
        it.defaultCodecs().maxInMemorySize($maxInMemorySize);
    }

    private static final Mono authFilter$lambda$1(HttpServletRequest $request, ClientRequest apiGatewayRequest, ExchangeFunction next) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)apiGatewayRequest, (String)"apiGatewayRequest");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        String[] stringArray = new String[]{$request.getHeader("Authorization")};
        ClientRequest.Builder builder = ClientRequest.from((ClientRequest)apiGatewayRequest).header("Authorization", stringArray);
        stringArray = new String[]{$request.getHeader("just-token")};
        return next.exchange(builder.header("just-token", stringArray).build());
    }

    private static final Mono acceptLanguage$lambda$2(HttpServletRequest $request, ClientRequest apiGatewayRequest, ExchangeFunction next) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)apiGatewayRequest, (String)"apiGatewayRequest");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        String[] stringArray = new String[]{$request.getHeader("Accept-Language")};
        return next.exchange(ClientRequest.from((ClientRequest)apiGatewayRequest).header("Accept-Language", stringArray).build());
    }
}

