/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.tracking.controller;

import de.justsoftware.gateway.config.FeatureToggleService;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.tracking.TrackingService;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import java.security.Principal;
import java.time.Duration;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.webflux.ProxyExchange;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/holmes"})
public class TrackingController {
    private static final Logger LOG = LoggerFactory.getLogger(TrackingController.class);
    private final FeatureToggleService _featureToggleService;
    private final TrackingService _trackingService;
    private final String _holmesBaseUrl;

    public TrackingController(FeatureToggleService featureToggleService, TrackingService trackingService, @Value(value="http://${just.holmes.host}:${just.holmes.port}/holmes") String holmesBaseUri) {
        this._featureToggleService = featureToggleService;
        this._trackingService = trackingService;
        this._holmesBaseUrl = holmesBaseUri;
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @GetMapping(value={"/track"})
    @Nonnull
    Mono<Void> track(@RequestParam(value="t") String t, @RequestHeader HttpHeaders headers, ProxyExchange<byte[]> proxy, ServerHttpRequest request, Principal principal) {
        if (!this._featureToggleService.isTenantTrackingEnabled()) {
            String query = request.getURI().getRawQuery();
            String uri = this._holmesBaseUrl + "/track?" + query;
            LOG.debug("redirecting holmes request to uri {}", (Object)uri);
            return proxy.uri(uri).get().then();
        }
        TenantId tenantId = this.extractTenantId(principal);
        if (tenantId == null) {
            LOG.warn("no tenantId, no tracking");
            return Mono.empty();
        }
        Mono.delay((Duration)Duration.ofMillis(0L)).subscribe(l -> this._trackingService.track(t, tenantId, headers, request));
        return Mono.empty();
    }

    @CheckForNull
    private TenantId extractTenantId(Principal principal) {
        if (principal instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)principal;
            String tenantId = (String)jwtAuthenticationToken.getCustomJwtClaims().get((Object)"tenantId");
            if (tenantId != null) {
                return TenantId.parse((String)tenantId);
            }
        } else if (principal instanceof JustAuthToken) {
            JustAuthToken token = (JustAuthToken)principal;
            return token.getTenantId();
        }
        return null;
    }
}

