/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.internal.controllers;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import de.justsoftware.drive.batch.item.ItemPurgeSchedulerService;
import de.justsoftware.drive.business.authorization.AuthorizationContextProvider;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.change.ChangeService;
import de.justsoftware.drive.business.change.DriveChangePublisher;
import de.justsoftware.drive.business.change.HistoryCompactorJobStarter;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.business.document.DocumentPublisher;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.document.NameValidation;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.TempFileService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.search.DocumentSearchService;
import de.justsoftware.drive.business.shares.SharesPublisher;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.util.EntryStream;
import de.justsoftware.drive.rest.exceptions.BadRequestException;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.internal.controllers.InternalDocumentController;
import de.justsoftware.drive.rest.internal.models.InternalDriveRestoreChangeResponse;
import de.justsoftware.drive.rest.internal.models.InternalFileModel;
import de.justsoftware.drive.rest.models.TempFile;
import de.justsoftware.drive.rest.util.ContentDispositionUtil;
import de.justsoftware.drive.rest.util.MultipartUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/internal"}, produces={"application/json"})
@Tag(name="Internal Document Controller", description="Service 2 service API to create and load documents")
@ParametersAreNonnullByDefault
public class InternalDocumentController {
    static final String API_MAPPING = "/internal";
    private static final String REQUESTED_FILE_WAS_NOT_FOUND = "Requested file was not found";
    private final ChangeModificationService _changeModificationService;
    private final FolderService _folderService;
    private final DocumentTreeModificationService _documentTreeModificationService;
    private final FileService _fileService;
    private final DocumentSearchService _documentSearchService;
    private final TempFileService _tempFileService;
    private final DriveChangePublisher _driveChangePublisher;
    private final ChangeService _changeService;
    private final DocumentPublisher _documentPublisher;
    private final SharesPublisher _sharesPublisher;
    @CheckForNull
    private final HistoryCompactorJobStarter _historyCompactorJobStarter;
    private final AuthorizationContextProvider _authorizationContextProvider;
    @CheckForNull
    private final ItemPurgeSchedulerService _itemPurgeSchedulerService;

    @Autowired
    public InternalDocumentController(ChangeModificationService changeModificationService, FolderService folderService, DocumentTreeModificationService documentTreeModificationService, FileService fileService, DocumentSearchService documentSearchService, TempFileService tempFileService, DriveChangePublisher driveChangePublisher, ChangeService changeService, DocumentPublisher documentPublisher, SharesPublisher sharesPublisher, @Autowired(required=false) HistoryCompactorJobStarter historyCompactorJobStarter, @Autowired(required=false) ItemPurgeSchedulerService itemPurgeSchedulerService, AuthorizationContextProvider authorizationContextProvider) {
        this._changeModificationService = changeModificationService;
        this._folderService = folderService;
        this._documentTreeModificationService = documentTreeModificationService;
        this._fileService = fileService;
        this._documentSearchService = documentSearchService;
        this._driveChangePublisher = driveChangePublisher;
        this._tempFileService = tempFileService;
        this._changeService = changeService;
        this._documentPublisher = documentPublisher;
        this._sharesPublisher = sharesPublisher;
        this._historyCompactorJobStarter = historyCompactorJobStarter;
        this._authorizationContextProvider = authorizationContextProvider;
        this._itemPurgeSchedulerService = itemPurgeSchedulerService;
    }

    @RequestMapping(value={"/item/{itemId}"}, method={RequestMethod.POST})
    @Operation(description="Upload a new file")
    @Nonnull
    public InternalFileModel uploadFile(ItemId itemId, @RequestParam(value="ownerId") PersonId ownerId, @RequestParam(value="file") MultipartFile file) {
        ChangeBO change = this._changeModificationService.getOrCreateNewestChange(itemId, ownerId, PublishedFilter.ONLY_PUBLISHED, null);
        return this.addFileToFolder(ownerId, file, change.getId(), null);
    }

    @RequestMapping(value={"/tmp/upload"}, method={RequestMethod.POST}, produces={"application/json"})
    @Operation(description="Upload temporary files")
    @Nonnull
    public List<TempFile> uploadTempFiles(@RequestParam(value="ownerId") PersonId ownerId, MultipartFile ... files) {
        Iterable byteSources = Stream.of(files).map(MultipartUtil.MULTIPART_FILE_TO_BYTESOURCE).collect(Collectors.toList());
        ImmutableMap tempFiles = this._tempFileService.addTempFiles(byteSources, ownerId);
        return (List)EntryStream.from((Map)tempFiles).map((id, byteSource) -> {
            String filename = byteSource.getFilename();
            String mimeType = FileMetaInfoUtil.getMimeTypeFromSource((String)filename, (ByteSource)byteSource.getByteSource());
            return new TempFile(id, filename, mimeType);
        }).collect(ImmutableList.toImmutableList());
    }

    @RequestMapping(value={"/tmp/uploadFromUrls"}, method={RequestMethod.POST}, produces={"application/json"})
    @Operation(description="Upload temporary files")
    @Nonnull
    public List<TempFile> uploadTempFilesFromUrl(@RequestBody AddTempFilesFromUrlsRequest request) {
        List filesToUpload = request._fileUrls.stream().map(u -> {
            try {
                URL url = new URL(u.replaceAll(" ", "%20"));
                ByteSource byteSource = Resources.asByteSource((URL)url);
                String[] parts = url.getFile().split("/");
                String filename = parts[parts.length - 1].replaceAll("%20", " ");
                return new ByteSourceWithFilename(byteSource, filename, Optional.absent());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("could not download attachment at " + u, e);
            }
        }).collect(Collectors.toList());
        ImmutableMap tempFiles = this._tempFileService.addTempFiles(filesToUpload, request._ownerId);
        return (List)EntryStream.from((Map)tempFiles).map((id, byteSource) -> {
            String filename = byteSource.getFilename();
            String mimeType = FileMetaInfoUtil.getMimeTypeFromSource((String)filename, (ByteSource)byteSource.getByteSource());
            return new TempFile(id, filename, mimeType);
        }).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private InternalFileModel addFileToFolder(PersonId ownerId, MultipartFile file, DocumentVersionId folderVersionId, @Nullable String purpose) {
        FolderVersionBO folder = (FolderVersionBO)this._folderService.getFolderVersionsByIds((Set)ImmutableSet.of((Object)folderVersionId)).get((Object)folderVersionId);
        if (folder == null) {
            throw new UnknownResourceBusinessException("not found");
        }
        ImmutableMap addedFiles = this._documentTreeModificationService.addFiles(folder.getDocumentId(), (Iterable)ImmutableList.of((Object)MultipartUtil.multipartFileToByteSource((MultipartFile)file)), ownerId, purpose, NameValidation.CLEAN_NAME);
        return this.loadInternalFileModel((DocumentVersionId)Iterables.getOnlyElement((Iterable)addedFiles.keySet()));
    }

    @RequestMapping(value={"/fileversion/{versionId}/download"}, method={RequestMethod.GET})
    @Operation(description="Download a file version")
    public void downloadFileVersion(HttpServletResponse response, @PathVariable DocumentVersionId versionId) {
        FileVersionBO fileVersion = this._fileService.getSingleVersionById(versionId);
        if (fileVersion == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        this.sendFileVersionStream(response, fileVersion);
    }

    @RequestMapping(value={"/file/{documentId}/delete"}, method={RequestMethod.DELETE})
    @Operation(description="Delete the file with the given documentId in the context of the provided user")
    public void deleteFiles(@PathVariable(value="documentId") DocumentId documentId, @RequestParam(value="deletingUser") PersonId deletingUser) {
        PersonAuthorizationContext authCtx = this._authorizationContextProvider.forPerson(deletingUser);
        boolean mayDelete = authCtx.may((AbstractId)documentId, StaticAction.DOCUMENT_DELETE);
        boolean mayDeleteOwnDocument = authCtx.may((AbstractId)documentId, StaticAction.DOCUMENT_DELETE_BY_OWNER);
        boolean mayManage = authCtx.may((AbstractId)documentId, StaticAction.SHARE_MANAGE);
        if (!(mayDelete || mayManage || mayDeleteOwnDocument)) {
            throw new PermissionDeniedException("not allowed");
        }
        this._documentTreeModificationService.deleteDocument(documentId, deletingUser);
    }

    @RequestMapping(value={"/file/{documentId}/download"}, method={RequestMethod.GET})
    @Operation(description="Download the latest version of the given file")
    public void downloadLatestVersion(HttpServletResponse response, @PathVariable DocumentId documentId) {
        FileVersionBO fileVersion = this._fileService.getLastFileVersion(documentId, PublishedFilter.ONLY_PUBLISHED);
        if (fileVersion == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        this.sendFileVersionStream(response, fileVersion);
    }

    private void sendFileVersionStream(HttpServletResponse response, FileVersionBO fileVersion) {
        ByteSource fileSource = this._fileService.getFileByteSource(fileVersion);
        try {
            response.setContentType(fileVersion.getMimeType());
            response.setContentLengthLong(fileVersion.getFileSize());
            ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)fileVersion.getName());
            fileSource.copyTo((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
    }

    @Operation(description="Trigger reindex of all documents in drive search")
    @RequestMapping(value={"/reindex"}, method={RequestMethod.POST})
    public void reindexAllDocuments() {
        this._documentSearchService.reindexAllDocuments();
    }

    @Operation(description="Triggers republishing of all changes to Kafka")
    @RequestMapping(value={"/publishChanges"}, method={RequestMethod.POST})
    public void publishAllChanges() {
        Iterable allChangesWithTriggers = this._changeService.getAllChangesWithTriggers();
        allChangesWithTriggers.forEach(iteratorSupplier -> this._driveChangePublisher.publishAllChanges((Iterator)iteratorSupplier.get()));
    }

    @Operation(description="Trigger republishing of documents to Kafka")
    @RequestMapping(value={"/publishDocuments"}, method={RequestMethod.POST})
    public void publishDocuments() {
        this._documentPublisher.publishAllItems();
    }

    @Operation(description="Trigger republishing of all permission to the permission service.")
    @PostMapping(value={"/publishDrivePermissions"})
    public void publishDrivePermissions() {
        this._sharesPublisher.publishAllSharePermissions();
    }

    @Operation(description="Trigger the job to compact the drive history.")
    @PostMapping(value={"/runDriveHistoryCompactionJob"})
    public void runDriveHistoryCompactionJob() {
        if (this._historyCompactorJobStarter != null) {
            this._historyCompactorJobStarter.startNow();
        }
    }

    @Operation(description="Trigger the job to purge deleted items from Drive and other services.")
    @PostMapping(value={"/runItemPurgeJob"})
    public void runItemPurgeJob() {
        if (this._itemPurgeSchedulerService != null) {
            this._itemPurgeSchedulerService.purgeDeletedItemsNow();
        }
    }

    @Operation(description="Dispatch delete request for all preview sources in just-documents.")
    @DeleteMapping(value={"/deletePreviewSources"})
    public void deletePreviewSources() {
        this._tempFileService.deletePreviewSources();
    }

    @Nonnull
    @Operation(description="Get status of drive infos")
    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    public String status() {
        return "{\"status\": \"ok\"}";
    }

    @Operation(description="removes an uploaded file when an rollback is done")
    @RequestMapping(value={"/file/{fileId}/rollback"}, method={RequestMethod.POST})
    public void rollbackFile(@PathVariable DocumentId fileId) {
        if (this._documentTreeModificationService.rollbackFiles((Set)ImmutableSet.of((Object)fileId)).isEmpty()) {
            throw new UnknownResourceException("no versions found");
        }
    }

    @RequestMapping(value={"/tmp/move"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Operation(description="Attach the files with the given IDs from Drive's temporary storage to an item. The target item can have an optional parent item. When the call returns successfully, the files belong to the given owner")
    @Nonnull
    public ImmutableMap<TempFileId, InternalFileModel> moveTempFilesToItems(@RequestBody TempFileMoveRequest moveRequest) {
        ImmutableMap moveResult = this._tempFileService.moveTempFilesToItem((Set)ImmutableSet.copyOf((Collection)moveRequest._tempFileIds), moveRequest._targetItemId, moveRequest._parentItemId, moveRequest._ownerId);
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)moveResult, InternalFileModel::new));
    }

    @RequestMapping(value={"/restoreDriveChange"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Operation(description="restores a change and returns the new change id.it could be the same or the id of the last change if nothing needs to be changed, e.g. if it is called multiple")
    @CheckForNull
    public InternalDriveRestoreChangeResponse restoreDriveChange(@RequestBody RestoreDriveChangeRequest request) {
        ChangeBO result = this._documentTreeModificationService.restoreVersion(request._change, request._person, request._purpose);
        if (result == null) {
            throw new UnknownResourceException("no change found");
        }
        return new InternalDriveRestoreChangeResponse(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/item/{itemId}/replace"}, method={RequestMethod.POST})
    @Operation(description="Replace a file if it exist or upload a new")
    @Nonnull
    public InternalFileModel replaceFile(ItemId itemId, @RequestParam(value="ownerId") PersonId ownerId, @RequestParam(value="file") MultipartFile file, @RequestParam(value="purpose", required=false) String purpose) {
        ChangeBO change = this._changeModificationService.getOrCreateNewestChange(itemId, ownerId, PublishedFilter.ONLY_PUBLISHED, null);
        ImmutableListMultimap currentContent = this._folderService.getFolderContents((Set)ImmutableSet.of((Object)change.getId()));
        ByteSourceWithFilename byteSource = MultipartUtil.multipartFileToByteSource((MultipartFile)file);
        Optional existing = Iterables.tryFind((Iterable)currentContent.values(), d -> byteSource.getFilename().equals(d.getName()));
        if (!existing.isPresent()) {
            return this.addFileToFolder(ownerId, file, change.getId(), purpose);
        }
        FileVersionBO existingFile = (FileVersionBO)((DocumentVersionBO)existing.get()).accept(Functions.identity(), folder -> {
            throw new BadRequestException("document is a folder: " + folder);
        });
        try (InputStream in12 = this._fileService.getFileByteSource(existingFile).openBufferedStream();
             InputStream in2 = byteSource.getByteSource().openBufferedStream();){
            if (IOUtils.contentEquals((InputStream)in12, (InputStream)in2)) {
                InternalFileModel internalFileModel = new InternalFileModel(existingFile);
                return internalFileModel;
            }
        }
        catch (IOException in12) {
            // empty catch block
        }
        FileVersionBO newFile = this._documentTreeModificationService.uploadNewFileVersion(existingFile.getDocumentId(), byteSource, ownerId, purpose);
        return new InternalFileModel(newFile);
    }

    @Nonnull
    private InternalFileModel loadInternalFileModel(DocumentVersionId newFileId) {
        FileVersionBO file = (FileVersionBO)this._fileService.getVersionsByIds((Set)ImmutableSet.of((Object)newFileId)).get((Object)newFileId);
        return new InternalFileModel((FileVersionBO)Preconditions.checkNotNull((Object)file));
    }
}

