/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.folder;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import de.justsoftware.drive.persistence.folder.SubFolderMapper;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class SubFolderDAOImpl
implements SubFolderDAO {
    private final DAOSupport _daoSupport;
    private final SubFolderMapper _subFolderMapper;

    @Autowired
    @ParametersAreNonnullByDefault
    public SubFolderDAOImpl(SubFolderMapper subFolderMapper, DAOSupport daoSupport) {
        this._subFolderMapper = subFolderMapper;
        this._daoSupport = daoSupport;
    }

    public void insertFolderVersionRelations(SetMultimap<DocumentVersionId, ? extends DocumentVersionId> childsPerParent) {
        for (Map.Entry entry : childsPerParent.entries()) {
            this._subFolderMapper.insertFolderSubFolders((DocumentVersionId)entry.getKey(), (DocumentVersionId)entry.getValue());
        }
    }

    public ImmutableSetMultimap<DocumentVersionId, DocumentVersionId> getSubFoldersByIds(Set<DocumentVersionId> folderVersions) {
        return this._daoSupport.partition(folderVersions).asSetMultimap((arg_0, arg_1) -> ((SubFolderMapper)this._subFolderMapper).getSubFoldersByIds(arg_0, arg_1));
    }

    public ImmutableMap<DocumentVersionId, DocumentVersionId> getCurrentParentsOfDocumentVersions(Set<DocumentVersionId> documentIds, PublishedFilter publishedFilter) {
        boolean filterPublicOnly = publishedFilter != PublishedFilter.PUBLISHED_OR_PRIVATE;
        return this._daoSupport.partition(documentIds).asMap((resultHandler, ids) -> this._subFolderMapper.getCurrentParentsOfDocumentVersions(resultHandler, ids, filterPublicOnly));
    }

    public void deleteByParentIntroducedInChange(Set<DocumentVersionId> parentChanges) {
        this._daoSupport.partition(parentChanges).noResult(arg_0 -> ((SubFolderMapper)this._subFolderMapper).deleteByParentIntroducedInChange(arg_0));
    }

    public Map<DocumentId, DocumentVersionId> getAllDocumentsWithLatestVersionInFolder(DocumentVersionId rootFolderId) {
        return this._daoSupport.partition(Set.of(rootFolderId)).asMap((resultHandler, documentVersionIds) -> this._subFolderMapper.getAllChildrenRecursive(resultHandler, rootFolderId));
    }

    public void deleteByChildIds(Set<? extends DocumentVersionId> documentVersionIds) {
        this._daoSupport.partition(documentVersionIds).noResult(arg_0 -> ((SubFolderMapper)this._subFolderMapper).deleteByChildIds(arg_0));
    }

    public void insertParentRelationshipForDocumentsInChange(DocumentVersionId changeId) {
        this._subFolderMapper.insertParentRelationshipForDocumentsInChange(changeId);
    }

    public void updateParentRelationshipForChange(DocumentVersionId from, DocumentVersionId to) {
        this._subFolderMapper.updateParentRelationshipForChange(from, to);
    }

    public void deleteAllForItem(ItemId itemId) {
        this._subFolderMapper.deleteAllForItem(itemId);
    }
}

