/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.file.DocumentSupportDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import de.justsoftware.drive.persistence.folder.FolderVersionDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DocumentSupportDAOImpl
implements DocumentSupportDAO {
    final FileVersionDAO _fileVersionDAO;
    final DocumentDAO _documentDAO;
    final SubFolderDAO _subFolderDAO;
    final FolderVersionDAO _folderVersionDAO;

    @Autowired
    public DocumentSupportDAOImpl(FileVersionDAO fileVersionDAO, FolderVersionDAO folderVersionDAO, DocumentDAO documentDAO, SubFolderDAO subFolderDAO) {
        this._fileVersionDAO = fileVersionDAO;
        this._folderVersionDAO = folderVersionDAO;
        this._documentDAO = documentDAO;
        this._subFolderDAO = subFolderDAO;
    }

    public ImmutableListMultimap<DocumentId, FileVersionBO> deleteFiles(Set<DocumentId> fileIds) {
        ImmutableListMultimap versions = this._fileVersionDAO.getVersionsByDocumentIds(fileIds, PublishedFilter.PUBLISHED_OR_PRIVATE);
        Set versionIds = versions.values().stream().map(DocumentVersionBO::getId).collect(Collectors.toSet());
        this._documentDAO.prepareDelete((Set)versions.keySet());
        this._subFolderDAO.deleteByChildIds(versionIds);
        this._fileVersionDAO.deleteFileVersions(versionIds);
        this._documentDAO.deleteFinally((Set)versions.keySet());
        return versions;
    }

    public void deleteFolders(Set<DocumentId> unfilteredIds) {
        ImmutableSetMultimap foldersById = this._folderVersionDAO.getVersionsByDocumentIds(unfilteredIds);
        ImmutableSet folderIds = foldersById.keySet();
        Set folderVersion = Set.copyOf(foldersById.values());
        this._documentDAO.prepareDelete((Set)folderIds);
        this._subFolderDAO.deleteByChildIds(folderVersion);
        this._folderVersionDAO.deleteByIds(folderVersion);
        this._documentDAO.deleteFinally((Set)folderIds);
    }

    public ImmutableListMultimap<DocumentVersionId, DocumentVersionId> getPath(Set<DocumentVersionId> ids, PublishedFilter publishedFilter) {
        return this.getPath(ids, Functions.identity(), publishedFilter);
    }

    @Nonnull
    private <T> ImmutableListMultimap<T, DocumentVersionId> getPath(Set<T> ids, Function<? super T, DocumentVersionId> versionIdFunction, PublishedFilter publishedFilter) {
        HashMap known = new HashMap();
        Object missing = FluentIterable.from(ids).transform(versionIdFunction).filter(Predicates.notNull()).toSet();
        while (!missing.isEmpty()) {
            ImmutableMap parents = this._subFolderDAO.getCurrentParentsOfDocumentVersions((Set)missing, publishedFilter);
            known.putAll(parents);
            missing = new HashSet(parents.values());
            missing.removeAll(known.keySet());
        }
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (T id : ids) {
            DocumentVersionId v = (DocumentVersionId)versionIdFunction.apply(id);
            LinkedList<DocumentVersionId> list = new LinkedList<DocumentVersionId>();
            while (v != null) {
                list.addFirst(v);
                v = (DocumentVersionId)known.get(v);
            }
            result.putAll(id, list);
        }
        return result.build();
    }

    public ImmutableSetMultimap<DocumentVersionId, DocumentVersionId> getFolderContentsRecursive(Set<DocumentVersionId> folderVersions) {
        Sets.SetView missing = folderVersions;
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        HashMultimap knownParents = HashMultimap.create();
        HashSet loaded = new HashSet();
        while (!missing.isEmpty()) {
            ImmutableSetMultimap children = this._subFolderDAO.getSubFoldersByIds(missing);
            for (Map.Entry e : children.asMap().entrySet()) {
                DocumentVersionId parent = (DocumentVersionId)e.getKey();
                Collection childList = (Collection)e.getValue();
                ImmutableSet allParents = ImmutableSet.builder().addAll((Iterable)knownParents.get((Object)parent)).add((Object)parent).build();
                for (DocumentVersionId child : childList) {
                    knownParents.putAll((Object)child, (Iterable)allParents);
                }
                for (DocumentVersionId interestingParent : Sets.intersection((Set)allParents, (Set)folderVersions)) {
                    result.putAll((Object)interestingParent, (Iterable)childList);
                }
            }
            loaded.addAll(missing);
            missing = Sets.difference((Set)children.inverse().keySet(), loaded);
        }
        return result.build();
    }

    public ImmutableMap<DocumentVersionId, DocumentVersionBO> getDocumentVersionsByIds(Set<DocumentVersionId> documentVersions) {
        ImmutableMap folders = this._folderVersionDAO.getFolderVersionsByIds(documentVersions);
        ImmutableMap files = this._fileVersionDAO.getByIds((Set)Sets.difference(documentVersions, (Set)folders.keySet()));
        return ImmutableMap.builder().putAll((Map)files).putAll((Map)folders).build();
    }

    public ImmutableListMultimap<DocumentVersionId, DocumentVersionBO> getDocumentVersionsByChangeIds(Set<DocumentVersionId> changeIds) {
        ImmutableListMultimap files = this._fileVersionDAO.getFileVersionsByChangeIds(changeIds);
        ImmutableListMultimap folders = this._folderVersionDAO.getFolderVersionsByChangeIds(changeIds);
        return ImmutableListMultimap.builder().putAll((Multimap)files).putAll((Multimap)folders).build();
    }
}

