/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.server.business.impl;

import de.justsoftware.drive.business.common.ConfigPropertiesFromZookeeper;
import de.justsoftware.drive.business.server.business.DriveVersionUpdateProcessor;
import de.justsoftware.drive.business.server.business.UpdateBehaviour;
import de.justsoftware.drive.common.versionupdate.model.UpdateProcessorType;
import de.justsoftware.drive.persistence.search.SearchIndexQueueDAO;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ReIndexDocumentMetadataUpdateProcessor
implements DriveVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReIndexDocumentMetadataUpdateProcessor.class);
    private static final UpdateProcessorType REINDEX_DOCUMENT_METADATA_TYPE = new UpdateProcessorType("REINDEX_DOCUMENT_METADATA");
    private final SearchIndexQueueDAO _searchIndexQueueDAO;
    private final ConfigPropertiesFromZookeeper _configPropertiesFromZookeeper;

    @Autowired
    public ReIndexDocumentMetadataUpdateProcessor(SearchIndexQueueDAO searchIndexQueueDAO, ConfigPropertiesFromZookeeper configPropertiesFromZookeeper) {
        this._searchIndexQueueDAO = searchIndexQueueDAO;
        this._configPropertiesFromZookeeper = configPropertiesFromZookeeper;
    }

    @Nonnull
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.UPDATE_ALWAYS_ON_PRIMARY;
    }

    public void process() {
        if (!this._configPropertiesFromZookeeper.isReIndexSearchOnUpdate()) {
            LOG.info("Do not re-index document data because re-index search on update is deactivated!");
            return;
        }
        this._searchIndexQueueDAO.insertAllDocuments(SearchIndexType.METADATA);
    }

    @Nonnull
    public UpdateProcessorType getProcessorType() {
        return REINDEX_DOCUMENT_METADATA_TYPE;
    }
}

