/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.migrationwiki;

import de.justsoftware.drive.business.kafka.serde.ItemIdDeserializer;
import de.justsoftware.drive.common.item.model.ItemId;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;

@Configuration
@EnableKafka
@Profile(value={"production"})
@ParametersAreNonnullByDefault
public class MigrationConsumerConfiguration {
    private final String _bootstrapServers;

    @Autowired
    public MigrationConsumerConfiguration(@Value(value="${just.drive.kafka.boostrapServers:}") String bootstrapServers) {
        this._bootstrapServers = bootstrapServers;
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, ItemId>> migrationConsumerFactory() {
        Map<String, Class<ItemIdDeserializer>> properties = Map.of("bootstrap.servers", this._bootstrapServers, "key.deserializer", ErrorHandlingDeserializer.class, "value.deserializer", ErrorHandlingDeserializer.class, "auto.offset.reset", "earliest", "group.id", "just.drive.wiki-drive-file-migration.consumer", "spring.deserializer.key.delegate.class", StringDeserializer.class, "spring.deserializer.value.delegate.class", ItemIdDeserializer.class);
        ConcurrentKafkaListenerContainerFactory listenerFactory = new ConcurrentKafkaListenerContainerFactory();
        listenerFactory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(properties));
        listenerFactory.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler());
        return listenerFactory;
    }
}

