/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.item;

import de.justsoftware.drive.business.common.ConfigPropertiesFromZookeeper;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.item.ItemWriteService;
import java.time.Duration;
import java.util.Date;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.SimpleTriggerContext;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"just.drive.itempurge.enabled", "just.drive.batchprocessing.enabled"})
@ParametersAreNonnullByDefault
public class ItemPurgeSchedulerService
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ItemPurgeSchedulerService.class);
    private static final CronTrigger CRON_TRIGGER = new CronTrigger("0 0 6 * * *");
    private final ItemReadService _itemReadService;
    private final ItemWriteService _itemWriteService;
    private final TaskScheduler _taskScheduler;
    private final ConfigPropertiesFromZookeeper _fileDeletionConfig;

    @Autowired
    public ItemPurgeSchedulerService(ItemReadService itemReadService, ItemWriteService itemWriteService, TaskScheduler taskScheduler, ConfigPropertiesFromZookeeper fileDeletionConfig) {
        this._itemReadService = itemReadService;
        this._itemWriteService = itemWriteService;
        this._taskScheduler = taskScheduler;
        this._fileDeletionConfig = fileDeletionConfig;
    }

    public void afterPropertiesSet() {
        Date nextExecution = CRON_TRIGGER.nextExecutionTime((TriggerContext)new SimpleTriggerContext());
        LOG.info("Schedule job to purge deleted items from database. Next execution at {}.", (Object)nextExecution);
        this._taskScheduler.schedule(() -> this.purgeDeletedItems(), (Trigger)CRON_TRIGGER);
    }

    public void purgeDeletedItemsNow() {
        this.purgeDeletedItems();
    }

    private void purgeDeletedItems() {
        Duration deletionDelay = this._fileDeletionConfig.getDeletionDelay();
        LOG.info("Purge items that are deleted for more than {} days.", (Object)deletionDelay.toDays());
        Set deletedItems = this._itemReadService.getDeletedItems(deletionDelay);
        Set purgedItems = this._itemWriteService.purge(deletedItems);
        LOG.info("Purged {} items.", (Object)purgedItems.size());
    }
}

