/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence.model;

import de.justsoftware.chat.persistence.model.DbAuditModel;
import de.justsoftware.chat.persistence.model.DbChatMessageReaction;
import de.justsoftware.chat.persistence.model.DbReactionId;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="ChatMessageReaction")
@IdClass(value=DbReactionId.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/chat/persistence/model/DbChatMessageReaction;", "Lde/justsoftware/chat/persistence/model/DbAuditModel;", "messageId", "Ljava/util/UUID;", "profileId", "", "reaction", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "getMessageId", "()Ljava/util/UUID;", "setMessageId", "(Ljava/util/UUID;)V", "getProfileId", "()Ljava/lang/String;", "setProfileId", "(Ljava/lang/String;)V", "getReaction", "setReaction", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "chat-service"})
public final class DbChatMessageReaction
extends DbAuditModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Id
    @NotNull
    private UUID messageId;
    @Id
    @NotNull
    private String profileId;
    @Column(nullable=false)
    @NotNull
    private String reaction;

    public DbChatMessageReaction(@NotNull UUID messageId, @NotNull String profileId, @NotNull String reaction) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        this.messageId = messageId;
        this.profileId = profileId;
        this.reaction = reaction;
    }

    @NotNull
    public final UUID getMessageId() {
        return this.messageId;
    }

    public final void setMessageId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.messageId = uUID;
    }

    @NotNull
    public final String getProfileId() {
        return this.profileId;
    }

    public final void setProfileId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.profileId = string;
    }

    @NotNull
    public final String getReaction() {
        return this.reaction;
    }

    public final void setReaction(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.reaction = string;
    }

    @NotNull
    public final UUID component1() {
        return this.messageId;
    }

    @NotNull
    public final String component2() {
        return this.profileId;
    }

    @NotNull
    public final String component3() {
        return this.reaction;
    }

    @NotNull
    public final DbChatMessageReaction copy(@NotNull UUID messageId, @NotNull String profileId, @NotNull String reaction) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        return new DbChatMessageReaction(messageId, profileId, reaction);
    }

    public static /* synthetic */ DbChatMessageReaction copy$default(DbChatMessageReaction dbChatMessageReaction, UUID uUID, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = dbChatMessageReaction.messageId;
        }
        if ((n & 2) != 0) {
            string = dbChatMessageReaction.profileId;
        }
        if ((n & 4) != 0) {
            string2 = dbChatMessageReaction.reaction;
        }
        return dbChatMessageReaction.copy(uUID, string, string2);
    }

    @NotNull
    public String toString() {
        return "DbChatMessageReaction(messageId=" + this.messageId + ", profileId=" + this.profileId + ", reaction=" + this.reaction + ")";
    }

    public int hashCode() {
        int result = this.messageId.hashCode();
        result = result * 31 + this.profileId.hashCode();
        result = result * 31 + this.reaction.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DbChatMessageReaction)) {
            return false;
        }
        DbChatMessageReaction dbChatMessageReaction = (DbChatMessageReaction)other;
        if (!Intrinsics.areEqual((Object)this.messageId, (Object)dbChatMessageReaction.messageId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profileId, (Object)dbChatMessageReaction.profileId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.reaction, (Object)dbChatMessageReaction.reaction);
    }

    public DbChatMessageReaction() {
    }
}

