/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.mobile.model.MobileSetting;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0005H\u0012J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0012J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/chat/mobile/service/MobileSettingsService;", "", "clock", "Ljava/time/Clock;", "react", "", "(Ljava/time/Clock;Z)V", "settings", "", "Lde/justsoftware/chat/mobile/model/MobileSetting;", "getSettings", "()Ljava/util/List;", "settingsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lde/justsoftware/chat/mobile/model/MobileSetting$SettingId;", "getSettingsUpdates", "since", "Ljava/time/Instant;", "set", "", "id", "value", "", "setEnabled", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMobileSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileSettingsService.kt\nde/justsoftware/chat/mobile/service/MobileSettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n766#2:59\n857#2,2:60\n*S KotlinDebug\n*F\n+ 1 MobileSettingsService.kt\nde/justsoftware/chat/mobile/service/MobileSettingsService\n*L\n48#1:59\n48#1:60,2\n*E\n"})
public class MobileSettingsService {
    @NotNull
    private final Clock clock;
    private final boolean react;
    @NotNull
    private final ConcurrentHashMap<MobileSetting.SettingId, MobileSetting> settingsMap;

    public MobileSettingsService(@NotNull Clock clock, @Value(value="${just.chat.toggles.react:false}") boolean react2) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.react = react2;
        this.settingsMap = new ConcurrentHashMap(MobileSetting.SettingId.values().length);
        this.set(MobileSetting.SettingId.JUCO_VERSION, "24.2.14-3876");
        this.set(MobileSetting.SettingId.CHAT_MAX_PARTICIPANTS, "2147483647");
        this.setEnabled(MobileSetting.SettingId.USER_GROUPS);
        this.setEnabled(MobileSetting.SettingId.ALL_USERS_USER_GROUP);
        this.setEnabled(MobileSetting.SettingId.PARTICIPANT_ROLES);
        this.setEnabled(MobileSetting.SettingId.IOS_SILENCE_ALERTS);
        this.setEnabled(MobileSetting.SettingId.MARK_CHAT_AS_UNREAD);
        this.setEnabled(MobileSetting.SettingId.MENTIONS);
        this.setEnabled(MobileSetting.SettingId.REPLY);
        this.set(MobileSetting.SettingId.REACT, this.react);
    }

    @NotNull
    public List<MobileSetting> getSettings() {
        Collection collection = this.settingsMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"settingsMap.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<MobileSetting> getSettingsUpdates(@NotNull Instant since) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable $this$filter$iv = this.getSettings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MobileSetting it = (MobileSetting)element$iv$iv;
            boolean bl = false;
            if (!it.getModifyDate().isAfter(since)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private void set(MobileSetting.SettingId id, String value) {
        Map map = this.settingsMap;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
        MobileSetting mobileSetting = new MobileSetting(id, value, instant);
        map.put(id, mobileSetting);
    }

    private void set(MobileSetting.SettingId id, boolean value) {
        this.set(id, String.valueOf(value));
    }

    private void setEnabled(MobileSetting.SettingId id) {
        this.set(id, true);
    }
}

