/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.tenant.TenantInvitationService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.TrackingSettingsService;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.model.TrackingSettings;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.kafka.publisher.Publisher;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/admin/domain/tenant/MatomoTrackingMigrationService;", "Lorg/springframework/beans/factory/InitializingBean;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "trackingSettingsService", "Lde/justsoftware/admin/domain/tenant/TrackingSettingsService;", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "tenantInvitationService", "Lde/justsoftware/admin/domain/tenant/TenantInvitationService;", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "(Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/tenant/TrackingSettingsService;Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/domain/tenant/TenantInvitationService;Lde/justsoftware/admin/domain/appsettings/AppSettingsService;)V", "afterPropertiesSet", "", "admin-service"})
public class MatomoTrackingMigrationService
implements InitializingBean {
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final TrackingSettingsService trackingSettingsService;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final TenantInvitationService tenantInvitationService;
    @NotNull
    private final AppSettingsService appSettingsService;

    public MatomoTrackingMigrationService(@NotNull TenantService tenantService, @NotNull TrackingSettingsService trackingSettingsService, @NotNull SuperopertyConnector superopertyConnector, @NotNull Publisher publisher, @NotNull TenantInvitationService tenantInvitationService, @NotNull AppSettingsService appSettingsService) {
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)trackingSettingsService, (String)"trackingSettingsService");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)tenantInvitationService, (String)"tenantInvitationService");
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        this.tenantService = tenantService;
        this.trackingSettingsService = trackingSettingsService;
        this.superopertyConnector = superopertyConnector;
        this.publisher = publisher;
        this.tenantInvitationService = tenantInvitationService;
        this.appSettingsService = appSettingsService;
    }

    public void afterPropertiesSet() {
        TenantId tenantId;
        TrackingSettings settingsFromDb;
        CharSequence charSequence = this.superopertyConnector.getPiwikSiteId();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || this.tenantService.getTenants().size() != 1 || (settingsFromDb = this.trackingSettingsService.findByTenantId(tenantId = ((Tenant)CollectionsKt.first((List)this.tenantService.getTenants())).getId())) != null && this.superopertyConnector.isTenantTrackingEnabled())) {
            TrackingSettings migratedSettings = new TrackingSettings(tenantId, this.superopertyConnector.getUserTrackingUrl(), this.superopertyConnector.getPiwikSiteId(), this.superopertyConnector.getPiwikTokenAuth(), this.superopertyConnector.getCookieBannerEnabled());
            this.trackingSettingsService.upsertSettings(migratedSettings);
            this.publisher.publishExistingTenant(this.tenantService.getTenant(tenantId), this.tenantService.getSettings(tenantId), (TenantInvitation)CollectionsKt.firstOrNull((List)this.tenantInvitationService.getTenantInvitations(tenantId)), (Collection)this.appSettingsService.getCoreAppsByTenant(tenantId), migratedSettings);
        }
    }
}

