/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.internal;

import de.justsoftware.admin.application.internal.InternalAppSettingsApplicationService;
import de.justsoftware.admin.application.internal.Repo;
import de.justsoftware.admin.config.ZookeeperConfig;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.kafka.publisher.Publisher;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012J\b\u0010\u000f\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/admin/application/internal/InternalAppSettingsApplicationService;", "", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "zookeeperConfig", "Lde/justsoftware/admin/config/ZookeeperConfig;", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/config/ZookeeperConfig;)V", "repo", "Lde/justsoftware/admin/application/internal/Repo;", "addMeetApp", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "addMeetAppToAllTenants", "Companion", "admin-service"})
@SourceDebugExtension(value={"SMAP\nInternalAppSettingsApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalAppSettingsApplicationService.kt\nde/justsoftware/admin/application/internal/InternalAppSettingsApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 InternalAppSettingsApplicationService.kt\nde/justsoftware/admin/application/internal/InternalAppSettingsApplicationService\n*L\n40#1:84,2\n*E\n"})
public class InternalAppSettingsApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final ZookeeperConfig zookeeperConfig;
    @Autowired
    private Repo repo;
    @NotNull
    private static final Logger log;

    public InternalAppSettingsApplicationService(@NotNull AppSettingsService appSettingsService, @NotNull Publisher publisher, @NotNull ZookeeperConfig zookeeperConfig) {
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)zookeeperConfig, (String)"zookeeperConfig");
        this.appSettingsService = appSettingsService;
        this.publisher = publisher;
        this.zookeeperConfig = zookeeperConfig;
    }

    @Async
    @EventListener(value={ApplicationReadyEvent.class})
    public void addMeetAppToAllTenants() {
        Repo repo = this.repo;
        if (repo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repo");
            repo = null;
        }
        Iterable $this$forEach$iv = repo.getTenantIdsWithoutMeetApp();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TenantId p0 = (TenantId)element$iv;
            boolean bl = false;
            this.addMeetApp(p0);
        }
    }

    private void addMeetApp(TenantId tenantId) {
        log.info("addMeetApp for '{}'", (Object)tenantId);
        ExternalAppSettings meetApp = ExternalAppSettings.Companion.withDefaultsForMeetApp(tenantId, this.zookeeperConfig.getHost(), false, this.appSettingsService.getLastPosition(tenantId));
        Set placements = SetsKt.emptySet();
        this.appSettingsService.createExternalApp(meetApp, (Collection)placements, ProfileId.Companion.fromValue(0L));
        this.publisher.publishUpdatedExternalAppSettings(meetApp, (Collection)placements);
        List apps = this.appSettingsService.getAppsByTenant(tenantId);
        this.publisher.publishUpdatedAppPositions((Collection)apps);
    }

    static {
        Logger logger = LoggerFactory.getLogger(InternalAppSettingsApplicationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

