BEGIN;

ALTER TABLE push_notification_device RENAME TO push_target_app;
ALTER SEQUENCE push_notification_device_seq RENAME TO push_target_app_seq;

ALTER TABLE push_target_app RENAME COLUMN device_id TO token;

ALTER TABLE push_target_app ADD COLUMN app_name VARCHAR(100);
UPDATE push_target_app SET app_name = 'MOBILE_NG_WRAPPER' WHERE app_name IS NULL;
ALTER TABLE push_target_app ALTER COLUMN app_name SET NOT NULL;

ALTER TABLE push_target_app DROP CONSTRAINT p_n_device_pk;
ALTER TABLE push_target_app ADD CONSTRAINT push_target_app_pk PRIMARY KEY (id);

ALTER TABLE push_target_app DROP CONSTRAINT p_n_device_uq;
ALTER TABLE push_target_app ADD CONSTRAINT push_target_app_uq UNIQUE (token, protocol);

ALTER TABLE push_target_app DROP CONSTRAINT p_n_device_person_fk;
ALTER TABLE push_target_app ADD CONSTRAINT push_target_app_person_fk FOREIGN KEY (person_id) REFERENCES person(id) ON DELETE CASCADE;

ALTER INDEX p_n_device_person_idx RENAME TO push_target_app_person_idx;

COMMIT;
