BEGIN;

------------------------     adjust table     ------------------------

-- move old table
ALTER TABLE user_setting RENAME TO old_user_setting;

-- create new table
CREATE TABLE user_setting (
    person_id numeric(10,0) NOT NULL,
    key varchar(30) NOT NULL,
    value varchar(4000) NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),
    FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE,
    PRIMARY KEY(person_id, key)
);

-- restore data to table
INSERT INTO user_setting (person_id, key, value, create_date, modify_date)
SELECT person_id, key, value, create_date, modify_date
FROM old_user_setting;

-- drop old table and sequence
DROP TABLE old_user_setting;
DROP SEQUENCE user_settings_seq;

------------------------ adjust shadow table ------------------------

-- move old shadow table
ALTER TABLE sh_user_setting RENAME TO old_sh_user_setting;

-- create new shadow table
CREATE TABLE sh_user_setting (
    "person_id" numeric(10,0),
    "key" character varying(30),
    "value" character varying(4000),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("person_id", "key")
);

-- restore data to new shadow table
INSERT INTO sh_user_setting ("person_id", "key", "value", "create_date", "modify_date", DELETE_ACTION_ID)
SELECT "person_id", "key", "value", "create_date", "modify_date", DELETE_ACTION_ID
FROM old_sh_user_setting;

-- drop old shadow table
DROP TABLE old_sh_user_setting;

COMMIT;
