begin;

create table subscriptions (
    subscriber_id bigint references person(id) on delete cascade not null,
    item_id bigint not null,
    item_type varchar(32) not null,
    subscription_type varchar(32) not null,
    subscription_state varchar(32) not null,
    created_at timestamp without time zone not null,
    modified_at timestamp without time zone not null,
    constraint subscriptions_pkey primary key (item_id, item_type, subscriber_id)
);

create table sh_subscriptions (
    subscriber_id bigint,
    item_id bigint,
    item_type varchar(32),
    subscription_type varchar(32),
    subscription_state varchar(32),
    created_at timestamp without time zone,
    modified_at timestamp without time zone,
    delete_action_id bigint,
    foreign key (delete_action_id) references delete_action (id)
);

insert into shadow_table (table_name,shadow_table_name,delete_action_mandatory) values ('subscriptions','sh_subscriptions','f');

insert into subscriptions(
       subscriber_id,
       item_id,
       item_type,
       subscription_type,
       subscription_state,
       created_at,
       modified_at)
select
    subscriber_id,
    item_id,
    item_type,
    case when passive='t' then 'PASSIVE'
         else 'DEFAULT' end,
    'SUBSCRIBED',
    created_at,
    modified_at
from like_subscribe
where subscriber_id in (select id from person);

insert into subscriptions(
       subscriber_id,
       item_id,
       item_type,
       subscription_type,
       subscription_state,
       created_at,
       modified_at)
select
    unsubscriber_id,
    item_id,
    item_type,
    'DEFAULT',
    'UNSUBSCRIBED_HIERARCHY',
    created_at,
    modified_at
from like_unsubscribe
where (unsubscriber_id, item_id, item_type) not in (select subscriber_id, item_id, item_type from subscriptions)
and unsubscriber_id in (select id from person);

delete from shadow_table where table_name = 'like_subscribe';
drop table like_subscribe;
drop table sh_like_subscribe;
delete from shadow_table where table_name = 'like_unsubscribe';
drop table like_unsubscribe;
drop table sh_like_unsubscribe;

commit;
