BEGIN;

CREATE SEQUENCE entity_status_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NO MAXVALUE
    CACHE 1;


-- define allowed status for an entity type
create table entity_status (
    id BIGINT NOT NULL,
    entity_type VARCHAR NOT NULL,
    status_name VARCHAR NOT NULL,
    default_status char(1) DEFAULT ('f') NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    modify_date timestamp without time zone DEFAULT now(),
    CONSTRAINT entity_status_pk PRIMARY KEY (id),
    CONSTRAINT entity_status_uq UNIQUE (entity_type, status_name)
);

-- who is allowed to to something depending on the entity status
create table entity_status_action (
    entity_status_id BIGINT NOT NULL,
    authority VARCHAR,
    action VARCHAR,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    modify_date timestamp without time zone DEFAULT now(),
    CONSTRAINT entity_status_action_fk FOREIGN KEY (entity_status_id) REFERENCES entity_status(id) ON DELETE CASCADE
);


CREATE SEQUENCE entity_process_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NO MAXVALUE
    CACHE 1;


-- assign business processes to an entity type in a specific state
create table entity_process (
    id BIGINT NOT NULL,
    entity_status_id BIGINT NOT NULL,
    process_definition VARCHAR,
    process_trigger VARCHAR,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    modify_date timestamp without time zone DEFAULT now(),
    CONSTRAINT entity_process_pk PRIMARY KEY (id),
    CONSTRAINT entity_process_status_fk FOREIGN KEY (entity_status_id) REFERENCES entity_status(id) ON DELETE CASCADE
);


-- mapping from entity status to process status
create table process_status_mapping (
    entity_process_id BIGINT NOT NULL,
    entity_status_id BIGINT NOT NULL,
    process_status VARCHAR(50),
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    modify_date timestamp without time zone DEFAULT now(),
    CONSTRAINT process_status_process_id_fk FOREIGN KEY (entity_process_id) REFERENCES entity_process(id) ON DELETE CASCADE,
    CONSTRAINT process_status_status_fk FOREIGN KEY (entity_status_id) REFERENCES entity_status(id) ON DELETE CASCADE
);

COMMIT;