BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00003, '7.8', '00003_#patch_add_passive_subscription_to_own_profile', 'FEATURE', '#8188 Zwangsabo auf eigenes Profil', now());

-- even though there shouldn't be any profile subscriptions yet: if there are, make sure they are passive
UPDATE like_subscribe
SET passive = 't'
WHERE subscriber_id = item_id AND item_type = 'PROFILE' AND passive = 'f';

INSERT INTO like_subscribe(subscriber_id, item_id, item_type, passive)
SELECT p.id, p.id, 'PROFILE', 't'
FROM person p
WHERE p.deleted = 'f' AND p.account_active = 't'
AND NOT EXISTS (
    SELECT 1
    FROM like_subscribe
    WHERE subscriber_id = p.id
    AND item_id = p.id
    AND item_type = 'PROFILE'
);

COMMIT;
