BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00001, '7.7', '00001_#patch_migrate_forum_to_workstream.sql', 'FEATURE', '#8017 Migration des Diskussionsforums in den Microblog', now());

-- Comment length is not limneted by the DB aymore
ALTER TABLE mdl_comment ALTER text TYPE text;

ALTER TABLE workstream_entry ADD COLUMN tmp_forum_id BIGINT;

-- Migrate topics

INSERT INTO workstream_entry(type,
                             origin_item_id,
                             origin_item_type,
                             author_id,
                             created_at,
                             modified_at,
                             subject_item_id,
                             subject_item_type,
                             tmp_forum_id)
SELECT 'MICROBLOG_POSTING', parent_item_id, parent_item_type, author_id, create_date, create_date, 0, 'WORKSTREAM_MESSAGE', id
FROM mdl_forum_topic;

UPDATE workstream_entry
SET subject_item_id = id
WHERE tmp_forum_id IS NOT NULL;

INSERT INTO workstream_entry_attribute(entry_id, key, value)
SELECT w.id, 'text', f.caption
FROM mdl_forum_topic f, workstream_entry w
WHERE f.id = w.tmp_forum_id;

-- Migrate articles

INSERT INTO mdl_comment(author_id,
                        text,
                        posted_at,
                        parent_item_id,
                        parent_item_type)
SELECT a.author_id, a.article_text, a.create_date, w.id, 'WORKSTREAM_MESSAGE'
FROM mdl_forum_topic_article a, workstream_entry w
WHERE a.topic_id = w.tmp_forum_id;

-- Drop old tables

DROP TABLE mdl_forum_topic CASCADE;
DROP TABLE mdl_forum_topic_article CASCADE;
DROP SEQUENCE mdl_forum_topic_seq;
DROP SEQUENCE mdl_forum_topic_article_seq;

DROP TABLE sh_mdl_forum_topic;
DROP TABLE sh_mdl_forum_topic_article;
DELETE FROM shadow_table WHERE table_name = 'mdl_forum_topic';
DELETE FROM shadow_table WHERE table_name = 'mdl_forum_topic_article';

-- Clean up

ALTER TABLE workstream_entry DROP COLUMN tmp_forum_id;

COMMIT;
