BEGIN;

-- ##########################################################################################
-- #                                   version info                                         #
-- ##########################################################################################

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00009, '7.6', '00009_#patch_refactor_member_mapping.sql', 'FEATURE', '#7239 Refaktorisierung der Datenbankstruktur von Mitgliedschaften in Entitäten', now());

-- ##########################################################################################
-- #                               handle active tables                                     #
-- ##########################################################################################

-- ################## create new mapping tables ##################

-- create new role mapping for specific roles on entities 
CREATE TABLE entity_member_role_name (
    name character varying(20) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT e_m_r_n_pk PRIMARY KEY (name)
);

-- map currently known roles and status values
INSERT INTO entity_member_role_name (name) VALUES ('ADMIN');
INSERT INTO entity_member_role_name (name) VALUES ('CO_ADMIN');
INSERT INTO entity_member_role_name (name) VALUES ('MEMBER');
INSERT INTO entity_member_role_name (name) VALUES ('HAS_REJECTED');
INSERT INTO entity_member_role_name (name) VALUES ('HAS_SENT_JOINREQUEST');
INSERT INTO entity_member_role_name (name) VALUES ('HAS_INVITATION');
INSERT INTO entity_member_role_name (name) VALUES ('IS_UNDECIDED');

-- create new mapping table with non modifiable entries
CREATE TABLE entity_member_role (
    person_id bigint NOT NULL,
    entity_id bigint NOT NULL,
    role character varying(20) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT e_m_pk PRIMARY KEY (entity_id, person_id, role),
    CONSTRAINT e_m_entity_fk FOREIGN KEY (entity_id) REFERENCES entity(id) ON DELETE CASCADE,
    CONSTRAINT e_m_person_fk FOREIGN KEY (person_id) REFERENCES person(id) ON DELETE CASCADE,
    CONSTRAINT e_m_role_fk FOREIGN KEY (role) REFERENCES entity_member_role_name (name) ON DELETE CASCADE
);

CREATE INDEX e_m_r_person_role_idx ON entity_member_role USING btree (person_id, role);
CREATE INDEX e_m_r_entity_role_idx ON entity_member_role USING btree (entity_id, role);

-- create specific table for invites and their invite message
CREATE TABLE entity_internal_invitation (
    person_id bigint NOT NULL,
    entity_id bigint NOT NULL,
    inviter_id bigint NOT NULL,
    invite_message text NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    CONSTRAINT e_i_i_pk PRIMARY KEY (entity_id, person_id),
    CONSTRAINT e_i_i_entity_fk FOREIGN KEY (entity_id) REFERENCES entity(id) ON DELETE CASCADE,
    CONSTRAINT e_i_i_person_fk FOREIGN KEY (person_id) REFERENCES person(id) ON DELETE CASCADE,
    CONSTRAINT e_i_i_inviter_fk FOREIGN KEY (inviter_id) REFERENCES person(id)
);

-- ################## transform current members ##################
--
-- current mapping info :
--
-- entity_member.member_status :
--     0 = IS_PARTICIPANT -> MEMBER
--     1 = HAS_REJECTED
--     2 = HAS_SENT_JOINREQUEST
--     3 = HAS_INVITATION
--     4 = IS_UNDECIDED
--
-- entity_member.member_role :
--     0 = WITHOUT_ROLE -> maps to nothing
--     1 = CO_ADMIN
--     2 = ADMIN

-- extract invitations (only fetch those that are active)
INSERT INTO entity_internal_invitation (person_id, entity_id, inviter_id, invite_message, create_date)
    SELECT person_id, entity_id, inviter_id, invite_message, create_date
    FROM entity_member
    WHERE member_status = 3
    AND   inviter_id IS NOT NULL
    AND   invite_message IS NOT NULL;

-- handle admins
INSERT INTO entity_member_role (person_id, entity_id, role, create_date)
    SELECT person_id, entity_id, 'ADMIN', modify_date
    FROM entity_member
    WHERE member_role = 2;

-- handle co-admins
INSERT INTO entity_member_role (person_id, entity_id, role, create_date)
    SELECT person_id, entity_id, 'CO_ADMIN', modify_date
    FROM entity_member
    WHERE member_role = 1;

-- handle users (do not differ by current role here, admins and co-admins are members as well)
INSERT INTO entity_member_role (person_id, entity_id, role, create_date)
    SELECT person_id, entity_id, 'MEMBER', modify_date
    FROM entity_member
    WHERE member_status = 0;

-- handle join requests
INSERT INTO entity_member_role (person_id, entity_id, role, create_date)
    SELECT person_id, entity_id, 'HAS_SENT_JOINREQUEST', modify_date
    FROM entity_member
    WHERE member_status = 2;

-- handle rejected
INSERT INTO entity_member_role (person_id, entity_id, role, create_date)
    SELECT person_id, entity_id, 'HAS_REJECTED', modify_date
    FROM entity_member
    WHERE member_status = 1;

-- handle invitations
INSERT INTO entity_member_role (person_id, entity_id, role, create_date)
    SELECT person_id, entity_id, 'HAS_INVITATION', modify_date
    FROM entity_member
    WHERE member_status = 3;


-- handle undecided
INSERT INTO entity_member_role (person_id, entity_id, role, create_date)
    SELECT person_id, entity_id, 'IS_UNDECIDED', modify_date
    FROM entity_member
    WHERE member_status = 4;

-- ################## delete backup of current mapping table ##################

DROP TABLE entity_member;

-- ##########################################################################################
-- #                               handle shadow tables                                     #
-- ##########################################################################################

-- ################## create new mapping tables ##################

-- create new mapping table with non modifiable entries
CREATE TABLE sh_entity_member_role (
    person_id bigint,
    entity_id bigint,
    role character varying(20),
    create_date timestamp without time zone,
    delete_action_id bigint,
    CONSTRAINT sh_e_m_r_pk PRIMARY KEY (entity_id, person_id, role, delete_action_id),
    CONSTRAINT sh_e_m_r_delete_fk FOREIGN KEY (delete_action_id) REFERENCES delete_action (id)
);

-- create specific table for invites and their invite message
CREATE TABLE sh_entity_internal_invitation (
    person_id bigint,
    entity_id bigint,
    inviter_id bigint,
    invite_message text,
    create_date timestamp without time zone,
    delete_action_id bigint,
    CONSTRAINT sh_e_i_i_pk PRIMARY KEY (entity_id, person_id, delete_action_id),
    CONSTRAINT sh_e_i_i_delete_fk FOREIGN KEY (delete_action_id) REFERENCES delete_action (id)
);

-- ################## transform current members ##################

-- extract invitations (only fetch those that are active)
INSERT INTO sh_entity_internal_invitation (person_id, entity_id, inviter_id, invite_message, create_date, delete_action_id)
    SELECT person_id, entity_id, inviter_id, CASE WHEN invite_message IS NULL THEN '' ELSE invite_message END, create_date, delete_action_id
    FROM sh_entity_member
    WHERE member_status = 3;

-- handle admins
INSERT INTO sh_entity_member_role (person_id, entity_id, role, create_date, delete_action_id)
    SELECT person_id, entity_id, 'ADMIN', modify_date, delete_action_id
    FROM sh_entity_member
    WHERE member_role = 2;

-- handle co-admins
INSERT INTO sh_entity_member_role (person_id, entity_id, role, create_date, delete_action_id)
    SELECT person_id, entity_id, 'CO_ADMIN', modify_date, delete_action_id
    FROM sh_entity_member
    WHERE member_role = 1;

-- handle users (do not differ by current role here, admins and co-admins are members as well)
INSERT INTO sh_entity_member_role (person_id, entity_id, role, create_date, delete_action_id)
    SELECT person_id, entity_id, 'MEMBER', modify_date, delete_action_id
    FROM sh_entity_member
    WHERE member_status = 0;

-- handle join requests
INSERT INTO sh_entity_member_role (person_id, entity_id, role, create_date, delete_action_id)
    SELECT person_id, entity_id, 'HAS_SENT_JOINREQUEST', modify_date, delete_action_id
    FROM sh_entity_member
    WHERE member_status = 2;

-- handle rejected
INSERT INTO sh_entity_member_role (person_id, entity_id, role, create_date, delete_action_id)
    SELECT person_id, entity_id, 'HAS_REJECTED', modify_date, delete_action_id
    FROM sh_entity_member
    WHERE member_status = 1;

-- handle invitations
INSERT INTO sh_entity_member_role (person_id, entity_id, role, create_date, delete_action_id)
    SELECT person_id, entity_id, 'HAS_INVITATION', modify_date, delete_action_id
    FROM sh_entity_member
    WHERE member_status = 3;


-- handle undecided
INSERT INTO sh_entity_member_role (person_id, entity_id, role, create_date, delete_action_id)
    SELECT person_id, entity_id, 'IS_UNDECIDED', modify_date, delete_action_id
    FROM sh_entity_member
    WHERE member_status = 4;

-- ################## delete current mapping table ##################

DELETE FROM SHADOW_TABLE
WHERE TABLE_NAME = 'entity_member'
AND   SHADOW_TABLE_NAME = 'sh_entity_member';

DROP TABLE sh_entity_member;

-- ################## add new shadow tables to mapping ##################

INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_internal_invitation','sh_entity_internal_invitation','f');

INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('entity_member_role','sh_entity_member_role','f');

COMMIT;
