BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01232, '6.4', 'add-subscription-persons-foreign-keys', 'BUGFIX', 'Adds foreign key constraints on person ids in subscriptions (fixes #2384)', now());

delete from subscription where id in (select id from subscription s left outer join person p on s.subscriber_id = p.person_id where p.person_id is null);
update subscription_notification set actor_id = -1 where id in (select id from subscription_notification s left outer join person p on s.actor_id =p.person_id where p.person_id is null);

alter table subscription add constraint subscription_subscriber_id_fkey foreign key (subscriber_id) references person(person_id) on delete cascade;
alter table subscription_notification alter column actor_id set default -1, add constraint subscription_notification_actor_fkey foreign key (actor_id) references person(person_id) on delete set default;

COMMIT;
