BEGIN;

CREATE TABLE dbmaintain_scripts (
    file_name varchar(150),
    file_last_modified_at bigint,
    checksum varchar(50),
    executed_at varchar(20),
    succeeded bigint
);

DROP TABLE IF EXISTS tmp_fill_dbmaintain;
CREATE TABLE tmp_fill_dbmaintain (
    version_id bigint,
    file_name character varying(150),
    file_last_modified_at bigint,
    checksum character varying(50) 
);

INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01176,'5.0/01176_initial-drop-create.sql',1352196039000,'805d8cc1ecddc9a0c01538e3f3785e92');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01177,'5.0/01177_5.11-create_user_settings.sql',1352196039000,'4349babf6b7d6f7a2bc10dc4c50e4bc0');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01179,'5.0/01179_repair-broken-wiki-links.sql',1352196039000,'f3c75faf6f7a20eb74eca8798401c3a1');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01180,'5.0/01180_order-greetings.sql',1352196039000,'4316dcfc78f23c4c5dfa696ecc3965c4');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01181,'5.0/01181_delete-unused-google-map-api-keys-property.sql',1352196039000,'0f273baf99c268b7e6f2e97f2a62d966');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01182,'5.0/01182_alter-column-employer-max-character.sql',1352196039000,'075c150ed19d6014392ebaa9069dfccc');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01183,'5.0/01183_add-unique-constraint-to-workstream.sql',1352196039000,'e6705ae1eca722195c9a18fc5235fff4');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01184,'5.0/01184_add-academic-title-and-pseudonym.sql',1352196039000,'72f4110042a18f464795dc5c8493b870');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01185,'5.0/01185_add-index-to-workstream.sql',1352196039000,'a7cb65b722ced09b936a0a4dc1faad52');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01186,'5.0/01186_create-person-roles-table.sql',1352196039000,'2cb46c4505e455173dd923f00da32252');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01187,'5.0/01187_create-person-to-role-relation.sql',1352196039000,'d2a04fd0f78fa2a3b8121b94a2e6ddf2');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01188,'5.0/01188_remove_superopertyprop_founding_networks_enabled.sql',1352196039000,'a8fcfab41ad302e693fb3575bbace728');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01189,'5.0/01189_remove_superopertyprop_profileStatus_activated.sql',1352196039000,'974e66c997d80b015c2891a8ef012b53');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01190,'5.0/01190_5.11-Add-on-delete-cascade-to-legacy-table.sql',1352196039000,'293b22440516f9c982516b30c5478943');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01191,'5.0/01191_remove_superopertyprop_personVisibilityForAll.sql',1352196039000,'5a577d3186b266719b7d7376a8655745');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01192,'5.0/01192_add-delete-cascade-to-album-and-image-tables.sql',1352196039000,'e405ac083a277e803e0d30c2ff4233ca');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01193,'5.0/01193_add-entity-member-roles-component-data.sql',1352196039000,'c6f215e838c0a06ea16f04aef09da04b');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01194,'5.0/01194_create-component-visibility-table.sql',1352196039000,'f94e17f96454c8069149fdc3f8f939ed');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01195,'5.0/01195_migrate-profile-visibility-to-new-table.sql',1352196039000,'6007ecd5d053c574d160ba1b4857a48b');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01196,'5.0/01196_rename-names-in-email-templates.sql',1352196039000,'589b345c3d9cfc37836677711543a718');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01197,'5.0/01197_migrate-superadmin-and-translation-roles.sql',1352196039000,'026fdaf9fed2891a48e691b7bc46dfca');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01198,'5.0/01198_drop-profile-component-visibility-not-null.sql',1352196039000,'291e4c5f5b177ffdc1d86d323400d660');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01199,'5.0/01199_update-type-for-public-search-superoperty-description.sql',1352196039000,'8865993ff11b69e95f69ebc76aa201dc');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01200,'5.0/01200_add-foreign-key-constraint-to-dynamic-attributes.sql',1352196039000,'042947b8e07909b9c49ffedd4c8932e3');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01201,'5.0/01201_create-email-logins-table.sql',1352196039000,'20025c318f3b94e6a2c1f2858b0e33ec');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01202,'5.0/01202_drop-foreign-key-constraint-from-profile-component-visibility.sql',1352196039000,'377fb865964bf87aa6057bb2a7fe5994');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01203,'5.0/01203_drop-table-entity_type_allowed_component.sql',1352196039000,'a4aecc28770bcee6707bc909ff2cb447');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01204,'5.0/01204_create-entity_component_open_for-table.sql',1352196039000,'d38fdb490dd6e0ad42297bcf79893041');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01205,'5.0/01205_repair-fck-toolbar.sql',1352196039000,'769ec3a362cbf279335b81748ed1fc1d');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01206,'5.0/01206_create-entity_linked_entity_type_privacy-for-roles.sql',1352196039000,'ae07073787722e0e95f25bef3214f10d');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01207,'5.0/01207_alter-and-migrate-entity-table-privacy-for-roles.sql',1352196039000,'12793c62513778b9f703fe1372159f06');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01208,'5.0/01208_alter-foreign-key-person_primary_network.sql',1352196039000,'90fa022526bad1f8f782a68437c00d3f');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01209,'5.0/01209_update-toolbar-colums-again.sql',1352196039000,'966deedc372a44bef462d033dfff288f');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01210,'5.0/01210_migrate-entity_component_open_for-table.sql',1352196039000,'73e0a217eb320d4267ed3afa405d3989');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01211,'5.0/01211_create-entity_options.sql',1352196039000,'e8223fb7bfd80b5b10fed56916bed011');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01212,'5.0/01212_create-facebook-user-table.sql',1352196039000,'30c6627d6ec6b9f4312ca8e1f0b7d468');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01213,'5.0/01213_create-jabber-synced-table.sql',1352196039000,'5301df3fff470aaead614f793234be9b');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01214,'5.0/01214_create-default-albums-mapping-table.sql',1352196039000,'73b27b815170e830747211d5ac98a93d');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01215,'5.0/01215_delete-superoperty-email-settings.sql',1352196039000,'2ada597a4d69b6e043ada0e513b07114');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01216,'5.0/01216_6.2-more-secure-hashed-user-id.sql',1352196039000,'d39c46775edf9c2e08615e0e08860580');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01217,'5.0/01217_drop-fk-constraint-on-profile_component_visibility.sql',1352196039000,'56e9b952a0888ef06f2d6c7ebb8d44ab');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01218,'5.0/01218_alter-default-birthday_visibility.sql',1352196039000,'41924def3bb3c4a77a5edcb39ef19a1c');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01220,'5.0/01220_add-video-file-upload-column.sql',1352196039000,'06543d6bc8f6a857ffce00cb11c21381');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01221,'5.0/01221_add-entities-partnersite-and-article.sql',1352196039000,'b823bc3e1e3521ae228c389e4ef9fac7');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01222,'5.0/01222_delete-unused-chat-superoperty-properties.sql',1352196039000,'9f9eebc0214de3a9fe1b5798e8c660f7');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01223,'5.0/01223_update-default-workstream-superoperty-properties.sql',1352196039000,'608554c82dd174c152d98715c0595b6f');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01224,'5.0/01224_add-general_visibility_to_person.sql',1352196039000,'4e15f330e9687c0eea4d671260043029');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01225,'5.0/01225_create-profile-visibility-table.sql',1352196039000,'8b37970a0d8372759e396e4c3ec5deac');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01228,'5.0/01228_replace-ADMIN-with-CO_ADMIN-in-entity-settings.sql',1352196039000,'b5be045e60434a4a8dff0e42b014c0aa');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01229,'5.0/01229_remove-ADMIN-from-profile_component_visibility.sql',1352196039000,'030a87aee57938f00854bda2f45464f2');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01230,'5.0/01230_6.4-email_users_unique_userid_domain.sql',1352196039000,'d8b5e784552a23a4d0635c9da7aa6294');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01231,'5.0/01231_6.4-email_users_unique_personid.sql',1352196039000,'baf05a7107324067389f50a756184f0d');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01232,'5.0/01232_6.4-add-subscription-persons-foreign-keys.sql',1352196039000,'03ea359d74de8c83e6baacda7d84636d');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01234,'5.0/01234_6.4-remove-WHOLE_LINKED_ENTITY.sql',1352196039000,'518d0f43b1f271659b7103d30afcdb54');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01235,'5.0/01235_6.5-remove-old-workstream-messages.sql',1352196039000,'ad3328b63bdde73841b70c62a5c44942');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01236,'5.0/01236_create-like-queue-table.sql',1352196039000,'9f906148e9ccf7c64118a8e925edc76f');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01239,'5.0/01239_refactor-subscription-like.sql',1352196039000,'e2341e28373c41a44248e199f9b3f1db');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01240,'5.0/01240_migrate-old-subscriptions.sql',1352196039000,'4b36c013a3bbe08f9a108408f98d2fe8');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01241,'5.0/01241_remove-domain-suffix-property.sql',1352196039000,'03f06e4b00af0f692a6ae2dcf32353ba');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01242,'5.0/01242_add-index-to-like_subscribe.sql',1352196039000,'03f1066262ccf2695c39b7238d439e9e');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01243,'6.0/01243_6.5-B-migrate_workstream_filter.sql',1352196039000,'2fc1521cf1ed441021add54d2e564310');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01244,'6.0/01244_forum-use-clock_timestamp.sql',1352196039000,'20998833ba93d8b559b1a3bf7e5fb449');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01245,'6.0/01245_remove-old-subscription-tables.sql',1352196039000,'36a55941abe871de2890940a6bb8f87d');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01246,'6.0/01246_add-unsubscribe-table.sql',1352196039000,'167ae5942e24682282ccab29b55c696c');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01247,'6.0/01247_6.5-B-add-tempory-chat-password-table.sql',1352196039000,'254284a2a2f38d8f221168981a2a2841');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01248,'6.0/01248_6.5-remove_superopertyprop_getSubscriptionLikeNotificationHTML.sql',1352196039000,'87df163bbbe61a089ec52d28ecb85902');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01249,'6.0/01249_add_email-notification-settings_table.sql',1352196039000,'c46cec81eb7a766dd55155fad2dae1f4');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01251,'6.0/01251_6.6-F-add-public-visible-attribute-to-entity.sql',1352196039000,'c776ad86cbcf8bf3ac364620fb7929f9');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01252,'6.0/01252_remove-default-search-context-from-superoperty.sql',1352196039000,'1e14c6e6dad7aefb6a2e4b4b1410f8f3');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01253,'6.0/01253_add-customized_title-to-entity-component.sql',1352196039000,'97295fe8e47ce53d80bdb8e4d713ad30');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01254,'6.0/01254_add-attachments-table-for-workstream-attachments.sql',1352196039000,'73e126b83cb74def1c107301f3858d72');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01255,'6.0/01255_add-parent_id-and-type-to-like-queue.sql',1352196039000,'f5a1c06560de463ab714adce9cbfb86d');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01256,'6.0/01256_remove-old-superoperty-keys-like-comment.sql',1352196039000,'cb13c936984cff0e8ff2f956c0f588d8');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01257,'6.0/01257_6.5-add-on-delete-set-default-to-survey-participant-id.sql',1352196039000,'aa45ee02d7ab486a96cb54e275b75e0c');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01258,'6.0/01258_workstream-use-clock_timestamp.sql',1352196039000,'6fe11958870c54db9256badde8850ae5');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01259,'6.0/01259_forum-use-clock_timestamp.sql',1352196039000,'1ce693082cf8be0946f1badd8e569427');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01260,'6.0/01260_6.6-B-remove-forum-topic-last-replier-id.sql',1352196039000,'7640d0cade685a24a9d305de8f1f38a6');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01261,'6.0/01261_6.7-drop-wallmessage-table.sql',1352196039000,'a50855ea0acad74cbc140302f02dce3b');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01262,'6.0/01262_6.7-drop-entity_type-table.sql',1352196039000,'8a1e68c7c976d1d0d5f01092c826b941');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01264,'6.0/01264_6.8-delete_settings_use_redirect.sql',1352196039000,'50019b484db05e5860b7019b3a285857');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01265,'6.0/01265_6.8-remove_unused_superoperty_settings.sql',1352196039000,'23eaad50f79f1dacf42422b14fc9176e');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01266,'6.0/01266_6.8-delete_unused_profile_properties.sql',1352196039000,'2175aafe7ff55cd0d79c7535b18ac3e9');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01267,'6.0/01267_6.8-delete_unused_properties.sql',1352196039000,'b778c2e051b1697b968c297c90a6603f');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01268,'6.0/01268_6.8-remove_unused_profile_properties.sql',1352196039000,'8a3d882f81eb461ecd04136eebf64f51');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01269,'6.0/01269_6.8-add_recent_to_like.sql',1352196039000,'c0ec1edffd221d18f60b6c398d238c61');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01270,'6.0/01270_6.8-adding_flag_for_streaming_workstreammessages_to_parent_entities.sql',1352196039000,'e2706596f673cfcfe6e303b0f3bf2b15');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01271,'6.0/01271_6.8-set-streaming-to-parents-for-entities.sql',1352196039000,'bfcab5033dcfc4e9faab845234947ca6');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01272,'6.0/01272_6.8-delete-unused-properties.sql',1352196039000,'f7d538619c1d109a8cd20d86b6d02d36');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01274,'6.0/01274_6.9-remove-admin-news.sql',1352196039000,'27bf5f172a773ff6a2adc382d859c62d');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01275,'6.0/01275_6.9-create-queueing-table.sql',1352196039000,'317e2a5d9a68ad79ddd099e0bbf70aef');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01276,'6.0/01276_6.9-remove-last-visitors.sql',1352196039000,'0aa3e8c5843be71c15fbb8b015f1549a');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01277,'6.0/01277_6.9-remove-do-you-know.sql',1352196039000,'053447a9f5748891e8cd00904211dc16');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01278,'6.0/01278_6.9-remove-unused-properties.sql',1352196039000,'669880135d7364eb28c732eb0e94f11a');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01279,'6.0/01279_6.9-drop-column-show-visits.sql',1352196039000,'1b06954c80dfd8dd121374878bc06bdf');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01280,'6.0/01280_remove-properties-for-workstream-streaming.sql',1352196039000,'d3f5987f215054e97fceffb15626c273');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01281,'6.0/01281_6.9-insert-send-join-request-rules.sql',1352196039000,'95dc4f8a8a36c3d5a25a3cf83c887eb6');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01282,'6.0/01282_6.9-change-statement-of-time.sql',1352196039000,'a8e934a62d22020a390128624acc8ea4');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01283,'6.0/01283_6.9-migrate-internal-videos.sql',1352196039000,'ef9a9ac763eb191a39ce1573916aff53');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01284,'6.0/01284_6.10-migrate-internal-videos.sql',1352196039000,'27cb9f1bfbfaea6e9d7fd0478a34ca08');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01286,'6.0/01286_6.10-migrate_entity_options.sql',1352196039000,'e993373cc7e3630b091f60bbb353f020');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01287,'6.0/01287_6.10-drop_entity_options.sql',1352196039000,'1f7986fceeb06eaf43a0d3a189890ffb');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01288,'6.0/01288_6.10-refactor-email-notification-settings.sql',1352196039000,'2094d7d45fd4bde86d7d57c36b8fd022');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01289,'6.0/01289_member-to-subscriptions.sql',1352196039000,'5704686d16b314b5a6d8913c00d2269e');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01291,'6.0/01291_6.10-B-profile_component_drop_visibility_column.sql',1352196039000,'0ecc7225bce8d5d31b854995dbc84564');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01292,'6.0/01292_6.11-fix_superoperty_property_names_word.sql',1352196039000,'4d1ea55028cde02823d7fb66095a1db2');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01293,'6.0/01293_6.11-create_search_index_queues.sql',1352196039000,'97299b758cdbd6669ec8d778e57926ed');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01294,'6.0/01294_6.11-migrate_entity_type_name.sql',1352196039000,'49942775a383f65a69b7a4faaa296d6a');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01295,'6.0/01295_6.11-remove_image_resize_dimensions.sql',1352196039000,'44eda6679161487878f12f1cb831a55f');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01296,'6.0/01296_6.11-remove_navigation_separator.sql',1352196039000,'8564d2eb85873766a02dd9a0821ed832');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01297,'6.0/01297_6.11-remove-navigation-border-property.sql',1352196039000,'274a6dff2d9f08a8b1cbff417924ceb3');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01298,'6.0/01298_6.11-remove-navigation-separator-from-default-design.sql',1352196039000,'46806f11a9a021780adf83fff0fc3411');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01299,'6.0/01299_6.12-migrate-component-type.sql',1352196035000,'7e760029d790f4ef5131f16638846bcf');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01300,'6.0/01300_6.12-remove-harcoded-entity-type-messages.sql',1352201829000,'a538a33866fe8196b10e9b4f6d672d7b');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01301,'6.0/01301_split-superoperty-search-filter-settings.sql',1352196035000,'be4c3a08c64782e14e923e0b0a80362c');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01302,'6.0/01302_6.12-migrate-entity-search-filter-labels.sql',1352201865000,'3f3d17fec10498ddc5091253ffc6bded');
INSERT INTO tmp_fill_dbmaintain (version_id,file_name,file_last_modified_at,checksum) VALUES (01303,'6.0/01303_6.12-fix-bad-entity-migrations.sql',1352196035000,'2e90f10b4b216f27b152bfc049087a97');
INSERT INTO dbmaintain_scripts(file_name,file_last_modified_at,checksum,executed_at,succeeded)
SELECT m.file_name, 
    m.file_last_modified_at, 
    m.checksum, 
    to_char(v."date", 'YYYY-MM-DD HH24:MI:SS') AS executed_at, 
    1 AS succeeded
FROM tmp_fill_dbmaintain m, version v
WHERE m.version_id = v.id
  AND file_name NOT IN (SELECT file_name FROM dbmaintain_scripts);

-- Manually add empty scripts. We need to find a way, to deal with those scripts. This works for now.
INSERT INTO dbmaintain_scripts(file_name,file_last_modified_at,checksum,executed_at,succeeded)
SELECT file_name, 
    file_last_modified_at, 
    checksum, 
    to_char(now(), 'YYYY-MM-DD HH24:MI:SS') AS executed_at, 
    1 AS succeeded
FROM tmp_fill_dbmaintain
WHERE version_id IN (1203, 1245, 1252, 1256, 1262, 1287, 1291, 1297) and version_id < (select max(id) from version)
  AND file_name NOT IN (SELECT file_name FROM dbmaintain_scripts);

DROP TABLE tmp_fill_dbmaintain;

COMMIT;
