/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.runner.impl;

import java.io.Reader;
import java.util.Map;
import javax.sql.DataSource;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.parser.ScriptParser;
import org.dbmaintain.script.parser.ScriptParserFactory;
import org.dbmaintain.script.runner.ScriptRunner;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.io.IOUtils;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcScriptRunner
implements ScriptRunner {
    private static Log logger = LogFactory.getLog(JdbcScriptRunner.class);
    protected Databases databases;
    protected SQLHandler sqlHandler;
    protected Map<String, ScriptParserFactory> databaseDialectScriptParserFactoryMap;

    public JdbcScriptRunner(Map<String, ScriptParserFactory> databaseDialectScriptParserFactoryMap, Databases databases, SQLHandler sqlHandler) {
        this.databaseDialectScriptParserFactoryMap = databaseDialectScriptParserFactoryMap;
        this.databases = databases;
        this.sqlHandler = sqlHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Script script) {
        Database targetDatabase;
        Reader scriptContentReader;
        block3: {
            scriptContentReader = null;
            try {
                targetDatabase = this.getTargetDatabaseDatabase(script);
                if (targetDatabase != null) break block3;
                logger.info("Script " + script.getFileName() + " has target database " + script.getTargetDatabaseName() + ". This database is disabled, so the script is not executed.");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(scriptContentReader);
                throw throwable;
            }
            IOUtils.closeQuietly(scriptContentReader);
            return;
        }
        scriptContentReader = script.getScriptContentHandle().openScriptContentReader();
        ScriptParser scriptParser = this.databaseDialectScriptParserFactoryMap.get(targetDatabase.getSupportedDatabaseDialect()).createScriptParser(scriptContentReader);
        this.parseAndExecuteScript(targetDatabase, scriptParser);
        IOUtils.closeQuietly(scriptContentReader);
    }

    private void parseAndExecuteScript(Database targetDatabase, ScriptParser scriptParser) {
        DataSource dataSource = targetDatabase.getDataSource();
        try {
            String statement;
            this.sqlHandler.startTransaction(dataSource);
            while ((statement = scriptParser.getNextStatement()) != null) {
                this.sqlHandler.execute(statement, dataSource);
            }
            this.sqlHandler.endTransactionAndCommit(dataSource);
        }
        catch (DbMaintainException e) {
            this.sqlHandler.endTransactionAndRollback(dataSource);
            throw e;
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void close() {
    }

    protected Database getTargetDatabaseDatabase(Script script) {
        String databaseName = script.getTargetDatabaseName();
        if (databaseName == null) {
            Database database = this.databases.getDefaultDatabase();
            if (database.getDatabaseInfo().isDisabled()) {
                return null;
            }
            return database;
        }
        if (!this.databases.isConfiguredDatabase(databaseName)) {
            throw new DbMaintainException("Error executing script " + script.getFileName() + ". No database initialized with the name " + script.getTargetDatabaseName());
        }
        return this.databases.getDatabase(databaseName);
    }
}

