/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.runner.impl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.runner.ScriptRunner;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.FileUtils;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

public abstract class BaseNativeScriptRunner
implements ScriptRunner {
    private static Log logger = LogFactory.getLog(BaseNativeScriptRunner.class);
    protected Databases databases;

    public BaseNativeScriptRunner(Databases databases) {
        this.databases = databases;
    }

    public void initialize() {
    }

    public void close() {
    }

    public void execute(Script script) {
        try {
            Database targetDatabase = this.getTargetDatabaseDatabase(script);
            if (targetDatabase == null) {
                logger.info("Script " + script.getFileName() + " has target database " + script.getTargetDatabaseName() + ". This database is disabled, so the script is not executed.");
                return;
            }
            File scriptFile = this.createTemporaryScriptFile(script);
            this.executeScript(scriptFile, targetDatabase);
        }
        catch (Exception e) {
            throw new DbMaintainException("Error executing script " + script.getFileName(), e);
        }
    }

    protected abstract void executeScript(File var1, Database var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createTemporaryScriptFile(Script script) throws IOException {
        File temporaryScriptsDir = this.createTemporaryScriptsDir();
        File temporaryScriptFile = new File(temporaryScriptsDir, this.getTemporaryScriptName(script));
        temporaryScriptFile.deleteOnExit();
        Reader scriptContentReader = script.getScriptContentHandle().openScriptContentReader();
        try {
            FileUtils.createFile(temporaryScriptFile, scriptContentReader);
        }
        finally {
            scriptContentReader.close();
        }
        return temporaryScriptFile;
    }

    protected String getTemporaryScriptName(Script script) {
        return System.currentTimeMillis() + script.getFileNameWithoutPath();
    }

    protected File createTemporaryScriptsDir() {
        String tempDir = System.getProperty("java.io.tmpdir");
        File temporaryScriptsDir = new File(tempDir, "dbmaintain");
        temporaryScriptsDir.mkdirs();
        return temporaryScriptsDir;
    }

    protected Database getTargetDatabaseDatabase(Script script) {
        String databaseName = script.getTargetDatabaseName();
        if (databaseName == null) {
            Database database = this.databases.getDefaultDatabase();
            if (database.getDatabaseInfo().isDisabled()) {
                return null;
            }
            return database;
        }
        if (!this.databases.isConfiguredDatabase(databaseName)) {
            throw new DbMaintainException("Error executing script " + script.getFileName() + ". No database initialized with the name " + script.getTargetDatabaseName());
        }
        return this.databases.getDatabase(databaseName);
    }
}

