/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.MessageDigest;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.ReaderInputStream;
import thirdparty.org.apache.commons.io.IOUtils;

public abstract class ScriptContentHandle {
    protected MessageDigest scriptDigest;
    protected Reader scriptReader;
    protected String encoding;
    protected boolean ignoreCarriageReturnsWhenCalculatingCheckSum;

    protected ScriptContentHandle(String encoding, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
        this.encoding = encoding;
        this.ignoreCarriageReturnsWhenCalculatingCheckSum = ignoreCarriageReturnsWhenCalculatingCheckSum;
    }

    public Reader openScriptContentReader() {
        try {
            this.scriptReader = new InputStreamReader(this.getScriptInputStream(), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new DbMaintainException("Unsupported encoding " + this.encoding, e);
        }
        return this.scriptReader;
    }

    public String getCheckSum() {
        try {
            MessageDigest scriptDigest = this.getScriptDigest();
            return this.getHexPresentation(scriptDigest.digest());
        }
        catch (IOException e) {
            throw new DbMaintainException(e);
        }
    }

    protected MessageDigest getScriptDigest() throws IOException {
        if (this.scriptDigest != null) {
            return this.scriptDigest;
        }
        InputStream scriptInputStream = null;
        try {
            int b;
            scriptInputStream = this.getScriptInputStream();
            this.scriptDigest = MessageDigest.getInstance("MD5");
            while ((b = scriptInputStream.read()) != -1) {
                if (this.ignoreCarriageReturnsWhenCalculatingCheckSum && b == 13) continue;
                this.scriptDigest.update((byte)b);
            }
            MessageDigest messageDigest = this.scriptDigest;
            return messageDigest;
        }
        catch (Exception e) {
            throw new DbMaintainException("Unable to calculate digest for script.", e);
        }
        finally {
            IOUtils.closeQuietly(scriptInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScriptContentsAsString(long maxNrChars) {
        String string;
        InputStream inputStream = this.getScriptInputStream();
        try {
            int c;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.encoding));
            StringWriter stringWriter = new StringWriter();
            long count = 0L;
            while ((c = bufferedReader.read()) != -1) {
                stringWriter.write(c);
                if (++count < maxNrChars) continue;
                stringWriter.write("... <remainder of script is omitted>");
                break;
            }
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                return "<script content could not be retrieved>";
            }
        }
        inputStream.close();
        return string;
    }

    protected String getHexPresentation(byte[] byteArray) {
        StringBuffer result = new StringBuffer();
        for (byte b : byteArray) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    protected abstract InputStream getScriptInputStream();

    public static class StringScriptContentHandle
    extends ScriptContentHandle {
        private String scriptContent;

        public StringScriptContentHandle(String scriptContent, String encoding, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
            super(encoding, ignoreCarriageReturnsWhenCalculatingCheckSum);
            this.scriptContent = scriptContent;
        }

        protected InputStream getScriptInputStream() {
            return new ReaderInputStream(new StringReader(this.scriptContent));
        }
    }

    public static class UrlScriptContentHandle
    extends ScriptContentHandle {
        private URL url;

        public UrlScriptContentHandle(URL url, String encoding, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
            super(encoding, ignoreCarriageReturnsWhenCalculatingCheckSum);
            this.url = url;
        }

        protected InputStream getScriptInputStream() {
            try {
                return this.url.openStream();
            }
            catch (IOException e) {
                throw new DbMaintainException("Error while trying to create reader for url " + this.url, e);
            }
        }
    }
}

