/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.launch.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.launch.task.DbMaintainDatabase;
import thirdparty.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskConfiguration {
    private Map<String, DataSource> dataSourcesPerDatabaseName = new HashMap<String, DataSource>();
    private Properties configuration;

    public TaskConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    public void addAllConfiguration(Properties customConfiguration) {
        if (customConfiguration == null) {
            return;
        }
        this.configuration.putAll((Map<?, ?>)customConfiguration);
    }

    public void addConfigurationIfSet(String propertyName, String propertyValue) {
        if (propertyValue != null) {
            this.configuration.put(propertyName, propertyValue);
        }
    }

    public void addConfigurationIfSet(String propertyName, Boolean propertyValue) {
        if (propertyValue != null) {
            this.configuration.put(propertyName, String.valueOf(propertyValue));
        }
    }

    public void addConfigurationIfSet(String propertyName, Long propertyValue) {
        if (propertyValue != null) {
            this.configuration.put(propertyName, String.valueOf(propertyValue));
        }
    }

    public void addDatabaseConfigurations(List<? extends DbMaintainDatabase> dbMaintainDatabases) {
        ArrayList<String> databaseNames = new ArrayList<String>();
        for (DbMaintainDatabase dbMaintainDatabase : dbMaintainDatabases) {
            String name = dbMaintainDatabase.getName();
            if (StringUtils.isBlank(name)) {
                name = "<unnamed>";
                if (databaseNames.contains(name)) {
                    throw new DatabaseException("Invalid database configuration. More than one unnamed database found.");
                }
                databaseNames.add(0, name);
            } else {
                if (databaseNames.contains(name)) {
                    throw new DatabaseException("Invalid database configuration. More than one database with name " + name + " found.");
                }
                databaseNames.add(name);
            }
            this.addDatabaseConfiguration(dbMaintainDatabase, name);
            DataSource dataSource = dbMaintainDatabase.getDataSource();
            if (dataSource == null) continue;
            this.dataSourcesPerDatabaseName.put(name, dataSource);
        }
        this.configuration.put("databases.names", StringUtils.join(databaseNames, ','));
    }

    protected void addDatabaseConfiguration(DbMaintainDatabase taskDatabase, String name) {
        this.addConfigurationIfSet("database." + name + '.' + "dialect", taskDatabase.getDialect());
        this.addConfigurationIfSet("database." + name + '.' + "driverClassName", taskDatabase.getDriverClassName());
        this.addConfigurationIfSet("database." + name + '.' + "url", taskDatabase.getUrl());
        this.addConfigurationIfSet("database." + name + '.' + "userName", taskDatabase.getUserName());
        this.addConfigurationIfSet("database." + name + '.' + "password", taskDatabase.getPassword());
        this.addConfigurationIfSet("database." + name + '.' + "schemaNames", taskDatabase.getSchemaNames());
        this.addConfigurationIfSet("database." + name + '.' + "included", taskDatabase.isIncluded());
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public Map<String, DataSource> getDataSourcesPerDatabaseName() {
        return this.dataSourcesPerDatabaseName;
    }
}

