/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.launch.task;

import java.util.List;
import org.dbmaintain.DbMaintainer;
import org.dbmaintain.MainFactory;
import org.dbmaintain.launch.task.DbMaintainDatabase;
import org.dbmaintain.launch.task.DbMaintainDatabaseTask;
import org.dbmaintain.launch.task.TaskConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckScriptUpdatesTask
extends DbMaintainDatabaseTask {
    protected String scriptLocations;
    protected String scriptEncoding;
    protected String postProcessingScriptDirectoryName;
    protected Boolean fromScratchEnabled;
    protected Boolean autoCreateDbMaintainScriptsTable;
    protected Boolean allowOutOfSequenceExecutionOfPatches;
    protected String qualifiers;
    protected String patchQualifiers;
    protected String includedQualifiers;
    protected String excludedQualifiers;
    protected String scriptFileExtensions;
    protected Boolean useLastModificationDates;

    public CheckScriptUpdatesTask() {
    }

    public CheckScriptUpdatesTask(List<DbMaintainDatabase> taskDatabases, String scriptLocations, String scriptEncoding, String postProcessingScriptDirectoryName, Boolean fromScratchEnabled, Boolean autoCreateDbMaintainScriptsTable, Boolean allowOutOfSequenceExecutionOfPatches, String qualifiers, String patchQualifiers, String includedQualifiers, String excludedQualifiers, String scriptFileExtensions, Boolean useLastModificationDates) {
        super(taskDatabases);
        this.scriptLocations = scriptLocations;
        this.scriptEncoding = scriptEncoding;
        this.postProcessingScriptDirectoryName = postProcessingScriptDirectoryName;
        this.fromScratchEnabled = fromScratchEnabled;
        this.autoCreateDbMaintainScriptsTable = autoCreateDbMaintainScriptsTable;
        this.allowOutOfSequenceExecutionOfPatches = allowOutOfSequenceExecutionOfPatches;
        this.qualifiers = qualifiers;
        this.patchQualifiers = patchQualifiers;
        this.includedQualifiers = includedQualifiers;
        this.excludedQualifiers = excludedQualifiers;
        this.scriptFileExtensions = scriptFileExtensions;
        this.useLastModificationDates = useLastModificationDates;
    }

    @Override
    protected void addTaskConfiguration(TaskConfiguration taskConfiguration) {
        taskConfiguration.addDatabaseConfigurations(this.databases);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.script.locations", this.scriptLocations);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.script.encoding", this.scriptEncoding);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.postProcessingScript.directoryName", this.postProcessingScriptDirectoryName);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.fromScratch.enabled", this.fromScratchEnabled);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.autoCreateDbMaintainScriptsTable", this.autoCreateDbMaintainScriptsTable);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.allowOutOfSequenceExecutionOfPatches", this.allowOutOfSequenceExecutionOfPatches);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.qualifiers", this.qualifiers);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.script.patch.qualifiers", this.patchQualifiers);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.includedQualifiers", this.includedQualifiers);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.excludedQualifiers", this.excludedQualifiers);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.script.fileExtensions", this.scriptFileExtensions);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.useScriptFileLastModificationDates", this.useLastModificationDates);
    }

    @Override
    protected boolean doExecute(MainFactory mainFactory) {
        DbMaintainer dbMaintainer = mainFactory.createDbMaintainer();
        dbMaintainer.updateDatabase(true);
        return true;
    }

    public void setScriptLocations(String scriptLocations) {
        this.scriptLocations = scriptLocations;
    }

    public void setScriptEncoding(String scriptEncoding) {
        this.scriptEncoding = scriptEncoding;
    }

    public void setPostProcessingScriptDirectoryName(String postProcessingScriptDirectoryName) {
        this.postProcessingScriptDirectoryName = postProcessingScriptDirectoryName;
    }

    public void setFromScratchEnabled(Boolean fromScratchEnabled) {
        this.fromScratchEnabled = fromScratchEnabled;
    }

    public void setAutoCreateDbMaintainScriptsTable(Boolean autoCreateDbMaintainScriptsTable) {
        this.autoCreateDbMaintainScriptsTable = autoCreateDbMaintainScriptsTable;
    }

    public void setAllowOutOfSequenceExecutionOfPatches(Boolean allowOutOfSequenceExecutionOfPatches) {
        this.allowOutOfSequenceExecutionOfPatches = allowOutOfSequenceExecutionOfPatches;
    }

    public void setQualifiers(String qualifiers) {
        this.qualifiers = qualifiers;
    }

    public void setPatchQualifiers(String patchQualifiers) {
        this.patchQualifiers = patchQualifiers;
    }

    public void setIncludedQualifiers(String includedQualifiers) {
        this.includedQualifiers = includedQualifiers;
    }

    public void setExcludedQualifiers(String excludedQualifiers) {
        this.excludedQualifiers = excludedQualifiers;
    }

    public void setUseLastModificationDates(Boolean useLastModificationDates) {
        this.useLastModificationDates = useLastModificationDates;
    }

    public void setScriptFileExtensions(String scriptFileExtensions) {
        this.scriptFileExtensions = scriptFileExtensions;
    }
}

