/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.launch.api;

import java.net.URL;
import java.util.Properties;
import org.dbmaintain.DbMaintainer;
import org.dbmaintain.MainFactory;
import org.dbmaintain.config.DbMaintainConfigurationLoader;
import org.dbmaintain.script.archive.ScriptArchiveCreator;
import org.dbmaintain.structure.clean.DBCleaner;
import org.dbmaintain.structure.clear.DBClearer;
import org.dbmaintain.structure.constraint.ConstraintsDisabler;
import org.dbmaintain.structure.sequence.SequenceUpdater;
import org.dbmaintain.util.DbMaintainException;

public class DbMaintainOperations {
    private static final String DBMAINTAIN_PROPERTIES = "dbmaintain.properties";

    public static void createScriptArchive(String archiveFileName) {
        ScriptArchiveCreator scriptArchiveCreator = DbMaintainOperations.getMainFactory().createScriptArchiveCreator();
        scriptArchiveCreator.createScriptArchive(archiveFileName);
    }

    public static void updateDatabase() {
        DbMaintainer dbMaintainer = DbMaintainOperations.getMainFactory().createDbMaintainer();
        dbMaintainer.updateDatabase(false);
    }

    public static void markDatabaseAsUptodate() {
        DbMaintainer dbMaintainer = DbMaintainOperations.getMainFactory().createDbMaintainer();
        dbMaintainer.markDatabaseAsUpToDate();
    }

    public static void clearDatabase() {
        DBClearer dbClearer = DbMaintainOperations.getMainFactory().createDBClearer();
        dbClearer.clearDatabase();
    }

    public static void cleanDatabase() {
        DBCleaner dbCleaner = DbMaintainOperations.getMainFactory().createDBCleaner();
        dbCleaner.cleanDatabase();
    }

    public static void disableConstraints() {
        ConstraintsDisabler constraintsDisabler = DbMaintainOperations.getMainFactory().createConstraintsDisabler();
        constraintsDisabler.disableConstraints();
    }

    public static void updateSequences() {
        SequenceUpdater sequenceUpdater = DbMaintainOperations.getMainFactory().createSequenceUpdater();
        sequenceUpdater.updateSequences();
    }

    private static MainFactory getMainFactory() {
        URL propertiesFromClassPath = ClassLoader.getSystemResource(DBMAINTAIN_PROPERTIES);
        if (propertiesFromClassPath == null) {
            throw new DbMaintainException("Could not find properties file dbmaintain.properties in classpath");
        }
        Properties configuration = new DbMaintainConfigurationLoader().loadConfiguration(propertiesFromClassPath);
        return new MainFactory(configuration);
    }
}

