/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.SQLHandler;
import thirdparty.org.apache.commons.dbutils.DbUtils;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSQLHandler
implements SQLHandler {
    private static Log logger = LogFactory.getLog(DefaultSQLHandler.class);
    private boolean doExecuteUpdates;
    private Map<DataSource, Connection> cachedConnections = new HashMap<DataSource, Connection>();

    public DefaultSQLHandler() {
        this(true);
    }

    public DefaultSQLHandler(boolean doExecuteUpdates) {
        this.doExecuteUpdates = doExecuteUpdates;
    }

    @Override
    public void execute(String sql, DataSource dataSource) {
        logger.debug(sql);
        if (!this.doExecuteUpdates) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.getConnection(dataSource).createStatement();
            statement.execute(sql);
        }
        catch (Exception e) {
            try {
                throw new DatabaseException("Could not perform database statement: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(statement);
    }

    @Override
    public int executeUpdateAndCommit(String sql, DataSource dataSource) {
        int n;
        logger.debug(sql);
        if (!this.doExecuteUpdates) {
            return 0;
        }
        Statement statement = null;
        try {
            Connection connection = this.getConnection(dataSource);
            statement = connection.createStatement();
            int nbChanges = statement.executeUpdate(sql);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            n = nbChanges;
        }
        catch (Exception e) {
            try {
                throw new DatabaseException("Error while performing database update:\n" + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(statement);
        return n;
    }

    @Override
    public long getItemAsLong(String sql, DataSource dataSource) {
        ResultSet resultSet;
        Statement statement;
        block4: {
            long l;
            logger.debug(sql);
            statement = null;
            resultSet = null;
            try {
                statement = this.getConnection(dataSource).createStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block4;
                l = resultSet.getLong(1);
            }
            catch (Exception e) {
                try {
                    throw new DatabaseException("Error while executing statement: " + sql, e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(null, statement, resultSet);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(null, statement, resultSet);
            return l;
        }
        DbUtils.closeQuietly(null, statement, resultSet);
        throw new DatabaseException("No item value found: " + sql);
    }

    @Override
    public String getItemAsString(String sql, DataSource dataSource) {
        ResultSet resultSet;
        Statement statement;
        block4: {
            String string;
            logger.debug(sql);
            statement = null;
            resultSet = null;
            try {
                statement = this.getConnection(dataSource).createStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block4;
                string = resultSet.getString(1);
            }
            catch (Exception e) {
                try {
                    throw new DatabaseException("Error while executing statement: " + sql, e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(null, statement, resultSet);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(null, statement, resultSet);
            return string;
        }
        DbUtils.closeQuietly(null, statement, resultSet);
        throw new DatabaseException("No item value found: " + sql);
    }

    @Override
    public Set<String> getItemsAsStringSet(String sql, DataSource dataSource) {
        HashSet<String> hashSet;
        logger.debug(sql);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.getConnection(dataSource).createStatement();
            resultSet = statement.executeQuery(sql);
            HashSet<String> result = new HashSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
            hashSet = result;
        }
        catch (Exception e) {
            try {
                throw new DatabaseException("Error while executing statement: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(null, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(null, statement, resultSet);
        return hashSet;
    }

    @Override
    public boolean exists(String sql, DataSource dataSource) {
        boolean bl;
        logger.debug(sql);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.getConnection(dataSource).createStatement();
            resultSet = statement.executeQuery(sql);
            bl = resultSet.next();
        }
        catch (Exception e) {
            try {
                throw new DatabaseException("Error while executing statement: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(null, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(null, statement, resultSet);
        return bl;
    }

    @Override
    public void startTransaction(DataSource dataSource) {
        Connection connection = this.getConnection(dataSource);
        try {
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Unable to start transaction.", e);
        }
    }

    @Override
    public void endTransactionAndCommit(DataSource dataSource) {
        Connection connection = this.getConnection(dataSource);
        try {
            connection.commit();
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (Exception t) {
                logger.warn("Unable to perform database rollback after commit failure.");
            }
            throw new DatabaseException("Error while performing database commit.", e);
        }
        finally {
            this.reenableAutoCommit(connection);
        }
    }

    @Override
    public void endTransactionAndRollback(DataSource dataSource) {
        Connection connection = this.getConnection(dataSource);
        try {
            connection.rollback();
        }
        catch (Exception e) {
            throw new DatabaseException("Unable to perform database rollback.", e);
        }
        finally {
            this.reenableAutoCommit(connection);
        }
    }

    private void reenableAutoCommit(Connection connection) {
        try {
            connection.setAutoCommit(true);
        }
        catch (Exception t) {
            logger.warn("Unable to re-enable auto commit behavior.");
        }
    }

    @Override
    public void closeAllConnections() {
        for (Connection connection : this.cachedConnections.values()) {
            DbUtils.closeQuietly(connection);
        }
        this.cachedConnections.clear();
    }

    protected Connection getConnection(DataSource dataSource) {
        Connection connection = this.cachedConnections.get(dataSource);
        if (connection == null) {
            try {
                connection = dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new DatabaseException("Error while creating connection", e);
            }
            this.cachedConnections.put(dataSource, connection);
        }
        return connection;
    }
}

