/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.config;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.dbmaintain.MainFactory;
import org.dbmaintain.config.PropertyUtils;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.qualifier.Qualifier;
import org.dbmaintain.script.qualifier.QualifierEvaluator;
import org.dbmaintain.script.qualifier.impl.IncludeExcludeQualifierEvaluator;
import org.dbmaintain.script.repository.ScriptLocation;
import org.dbmaintain.script.repository.ScriptRepository;
import org.dbmaintain.script.repository.impl.ArchiveScriptLocation;
import org.dbmaintain.script.repository.impl.FileSystemScriptLocation;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryContext {
    private Properties configuration;
    private MainFactory mainFactory;

    public FactoryContext(Properties configuration, MainFactory mainFactory) {
        this.configuration = configuration;
        this.mainFactory = mainFactory;
    }

    public Set<Qualifier> createQualifiers(List<String> qualifierNames) {
        HashSet<Qualifier> qualifiers = new HashSet<Qualifier>(qualifierNames.size());
        for (String qualifierName : qualifierNames) {
            qualifiers.add(new Qualifier(qualifierName));
        }
        return qualifiers;
    }

    public ScriptIndexes getBaselineRevision() {
        String baseLineRevisionString = PropertyUtils.getString("dbMaintainer.baseline.revision", null, this.configuration);
        if (StringUtils.isBlank(baseLineRevisionString)) {
            return null;
        }
        return new ScriptIndexes(baseLineRevisionString);
    }

    public ScriptRepository createScriptRepository() {
        HashSet<String> scriptLocationIndicators = new HashSet<String>(PropertyUtils.getStringList("dbMaintainer.script.locations", this.configuration));
        if (scriptLocationIndicators.isEmpty()) {
            throw new DbMaintainException("Unable to find scripts. No script locations specified.");
        }
        HashSet<ScriptLocation> scriptLocations = new HashSet<ScriptLocation>();
        for (String scriptLocationIndicator : scriptLocationIndicators) {
            scriptLocations.add(this.createScriptLocation(scriptLocationIndicator));
        }
        QualifierEvaluator qualifierEvaluator = this.createQualifierEvaluator(scriptLocations);
        return new ScriptRepository(scriptLocations, qualifierEvaluator);
    }

    public ScriptLocation createScriptLocation(String scriptLocation) {
        String scriptEncoding = PropertyUtils.getString("dbMaintainer.script.encoding", this.configuration);
        String postProcessingScriptDirName = PropertyUtils.getString("dbMaintainer.postProcessingScript.directoryName", this.configuration);
        Set<Qualifier> registeredQualifiers = this.createQualifiers(PropertyUtils.getStringList("dbMaintainer.qualifiers", this.configuration));
        Set<Qualifier> patchQualifiers = this.createQualifiers(PropertyUtils.getStringList("dbMaintainer.script.patch.qualifiers", this.configuration));
        String scriptIndexRegexp = PropertyUtils.getString("dbMaintainer.script.index.regexp", this.configuration);
        String qualifierRegexp = PropertyUtils.getString("dbMaintainer.script.qualifier.regexp", this.configuration);
        String targetDatabaseRegexp = PropertyUtils.getString("dbMaintainer.script.targetDatabase.regexp", this.configuration);
        HashSet<String> scriptFileExtensions = new HashSet<String>(PropertyUtils.getStringList("dbMaintainer.script.fileExtensions", this.configuration));
        boolean ignoreCarriageReturnsWhenCalculatingCheckSum = PropertyUtils.getBoolean("dbMaintainer.script.ignoreCarriageReturnsWhenCalculatingCheckSum", this.configuration);
        ScriptIndexes baseLineRevision = this.getBaselineRevision();
        File scriptLocationFile = new File(scriptLocation);
        if (scriptLocationFile.isDirectory()) {
            return new FileSystemScriptLocation(scriptLocationFile, scriptEncoding, postProcessingScriptDirName, registeredQualifiers, patchQualifiers, scriptIndexRegexp, qualifierRegexp, targetDatabaseRegexp, scriptFileExtensions, baseLineRevision, ignoreCarriageReturnsWhenCalculatingCheckSum);
        }
        return new ArchiveScriptLocation(scriptLocationFile, scriptEncoding, postProcessingScriptDirName, registeredQualifiers, patchQualifiers, scriptIndexRegexp, qualifierRegexp, targetDatabaseRegexp, scriptFileExtensions, baseLineRevision, ignoreCarriageReturnsWhenCalculatingCheckSum);
    }

    protected QualifierEvaluator createQualifierEvaluator(Set<ScriptLocation> scriptLocations) {
        Set<Qualifier> registeredQualifiers = this.getRegisteredQualifiers(scriptLocations);
        Set<Qualifier> includedQualifiers = this.createQualifiers(PropertyUtils.getStringList("dbMaintainer.includedQualifiers", this.configuration, false));
        Set<Qualifier> excludedQualifiers = this.createQualifiers(PropertyUtils.getStringList("dbMaintainer.excludedQualifiers", this.configuration, false));
        return new IncludeExcludeQualifierEvaluator(registeredQualifiers, includedQualifiers, excludedQualifiers);
    }

    protected Set<Qualifier> getRegisteredQualifiers(Set<ScriptLocation> scriptLocations) {
        Set<Qualifier> registeredQualifiers = this.createQualifiers(PropertyUtils.getStringList("dbMaintainer.qualifiers", this.configuration));
        for (ScriptLocation scriptLocation : scriptLocations) {
            registeredQualifiers.addAll(scriptLocation.getRegisteredQualifiers());
        }
        return registeredQualifiers;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public MainFactory getMainFactory() {
        return this.mainFactory;
    }
}

