/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.config;

import java.util.Properties;
import org.dbmaintain.config.PropertyUtils;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtils {
    public static <T> Class<T> getConfiguredClass(Class<T> type, Properties configuration, String ... implementationDiscriminatorValues) {
        String className = ConfigUtils.getConfiguredClassName(type, configuration, "implClassName", implementationDiscriminatorValues);
        return ReflectionUtils.getClassWithName(className);
    }

    public static <T> Class<T> getFactoryClass(Class<T> type, Properties configuration, String ... implementationDiscriminatorValues) {
        String className = ConfigUtils.getConfiguredClassName(type, configuration, "factory", implementationDiscriminatorValues);
        return ReflectionUtils.getClassWithName(className);
    }

    private static String getConfiguredClassName(Class<?> type, Properties configuration, String propertyName, String ... implementationDiscriminatorValues) {
        String propKey = type.getName() + "." + propertyName;
        if (implementationDiscriminatorValues != null) {
            String implementationSpecificPropKey = propKey;
            for (String implementationDiscriminatorValue : implementationDiscriminatorValues) {
                implementationSpecificPropKey = implementationSpecificPropKey + '.' + implementationDiscriminatorValue;
            }
            if (configuration.containsKey(implementationSpecificPropKey)) {
                return PropertyUtils.getString(implementationSpecificPropKey, configuration);
            }
        }
        if (configuration.containsKey(propKey)) {
            return PropertyUtils.getString(propKey, configuration);
        }
        throw new DbMaintainException("Missing configuration for " + propKey);
    }
}

