/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dbmaintain.DbMaintainer;
import org.dbmaintain.config.ConfigUtils;
import org.dbmaintain.config.Factory;
import org.dbmaintain.config.FactoryContext;
import org.dbmaintain.config.FactoryWithDatabase;
import org.dbmaintain.config.FactoryWithDatabaseContext;
import org.dbmaintain.config.FactoryWithoutDatabase;
import org.dbmaintain.database.DatabaseConnectionManager;
import org.dbmaintain.database.Databases;
import org.dbmaintain.database.DatabasesFactory;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.database.impl.DefaultDatabaseConnectionManager;
import org.dbmaintain.database.impl.DefaultSQLHandler;
import org.dbmaintain.datasource.impl.SimpleDataSourceFactory;
import org.dbmaintain.script.archive.ScriptArchiveCreator;
import org.dbmaintain.script.executedscriptinfo.ExecutedScriptInfoSource;
import org.dbmaintain.script.runner.ScriptRunner;
import org.dbmaintain.structure.clean.DBCleaner;
import org.dbmaintain.structure.clear.DBClearer;
import org.dbmaintain.structure.constraint.ConstraintsDisabler;
import org.dbmaintain.structure.sequence.SequenceUpdater;
import org.dbmaintain.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFactory {
    protected Properties configuration;
    protected SQLHandler sqlHandler;
    protected DatabaseConnectionManager databaseConnectionManager;
    protected Map<String, DataSource> dataSourcesPerDatabaseName;
    protected Databases databases;
    protected FactoryContext factoryContext;
    protected FactoryWithDatabaseContext factoryWithDatabaseContext;

    public MainFactory(Properties configuration) {
        this(configuration, new HashMap<String, DataSource>());
    }

    public MainFactory(Properties configuration, DatabaseConnectionManager databaseConnectionManager) {
        this.configuration = configuration;
        this.sqlHandler = databaseConnectionManager.getSqlHandler();
        this.databaseConnectionManager = databaseConnectionManager;
        this.dataSourcesPerDatabaseName = new HashMap<String, DataSource>();
    }

    public MainFactory(Properties configuration, Map<String, DataSource> dataSourcesPerDatabaseName) {
        this.configuration = configuration;
        this.sqlHandler = this.createSqlHandler();
        this.dataSourcesPerDatabaseName = dataSourcesPerDatabaseName;
    }

    public DbMaintainer createDbMaintainer() {
        return this.createInstance(DbMaintainer.class);
    }

    public DBCleaner createDBCleaner() {
        return this.createInstance(DBCleaner.class);
    }

    public DBClearer createDBClearer() {
        return this.createInstance(DBClearer.class);
    }

    public ConstraintsDisabler createConstraintsDisabler() {
        return this.createInstance(ConstraintsDisabler.class);
    }

    public SequenceUpdater createSequenceUpdater() {
        return this.createInstance(SequenceUpdater.class);
    }

    public ScriptRunner createScriptRunner() {
        return this.createInstance(ScriptRunner.class);
    }

    public ExecutedScriptInfoSource createExecutedScriptInfoSource() {
        return this.createInstance(ExecutedScriptInfoSource.class);
    }

    public ScriptArchiveCreator createScriptArchiveCreator() {
        return this.createInstance(ScriptArchiveCreator.class);
    }

    protected <S> S createInstance(Class<S> type) {
        Object factory = this.createFactoryForType(type);
        if (factory instanceof FactoryWithoutDatabase) {
            FactoryContext factoryContext = this.getFactoryContext();
            ((FactoryWithoutDatabase)factory).init(factoryContext);
        } else if (factory instanceof FactoryWithDatabase) {
            ((FactoryWithDatabase)factory).init(this.createFactoryWithDatabaseContext());
        }
        return (S)factory.createInstance();
    }

    protected synchronized FactoryContext getFactoryContext() {
        if (this.factoryContext == null) {
            this.factoryContext = new FactoryContext(this.configuration, this);
        }
        return this.factoryContext;
    }

    protected synchronized FactoryWithDatabaseContext createFactoryWithDatabaseContext() {
        if (this.factoryWithDatabaseContext == null) {
            Databases databases = this.getDatabases();
            this.factoryWithDatabaseContext = new FactoryWithDatabaseContext(this.configuration, this, databases, this.sqlHandler);
        }
        return this.factoryWithDatabaseContext;
    }

    protected <T extends Factory> T createFactoryForType(Class<?> type) {
        Class<?> clazz = ConfigUtils.getFactoryClass(type, this.configuration, new String[0]);
        return (T)((Factory)ReflectionUtils.createInstanceOfType(clazz, false, new Class[0], new Object[0]));
    }

    protected Databases getDatabases() {
        if (this.databases == null) {
            DatabaseConnectionManager databaseConnectionManager = this.getDatabaseConnectionManager();
            DatabasesFactory databasesFactory = new DatabasesFactory(this.configuration, databaseConnectionManager);
            this.databases = databasesFactory.createDatabases();
        }
        return this.databases;
    }

    protected DatabaseConnectionManager getDatabaseConnectionManager() {
        if (this.databaseConnectionManager == null) {
            SimpleDataSourceFactory dataSourceFactory = new SimpleDataSourceFactory();
            this.databaseConnectionManager = new DefaultDatabaseConnectionManager(this.configuration, this.sqlHandler, dataSourceFactory, this.dataSourcesPerDatabaseName);
        }
        return this.databaseConnectionManager;
    }

    protected SQLHandler createSqlHandler() {
        return new DefaultSQLHandler();
    }
}

