BEGIN;

-- delete entries for deleted tenants
DELETE FROM person_tenant where tenant_id NOT IN (SELECT id from tenant);
-- delete entries for deleted persons
DELETE FROM person_tenant pt WHERE person_id IN (SELECT id from person WHERE deleted='t');

-- add a foreign key to tenant to prevent inconsistent data
ALTER TABLE person_tenant ADD CONSTRAINT person_tenant_fk_t FOREIGN KEY (tenant_id) REFERENCES tenant (id);

-- add a foreign key to person to prevent inconsistent data
ALTER TABLE person_tenant ADD CONSTRAINT person_tenant_fk_p FOREIGN KEY (person_id) REFERENCES person (id);

COMMIT;
