BEGIN;

CREATE TABLE entity_type_app_mapping (
    entity_type varchar(32) NOT NULL,
    app_id varchar(100) NOT NULL,
    ctime timestamp NOT NULL DEFAULT now(),
    mtime timestamp NOT NULL DEFAULT now(),
    CONSTRAINT entity_type_app_map_pk PRIMARY KEY (entity_type),
    CONSTRAINT entity_type_app_map_etype_fk FOREIGN KEY (entity_type) REFERENCES entity_type_name(name) ON DELETE CASCADE,
    CONSTRAINT entity_type_app_map_app_id_fk FOREIGN KEY (app_id) REFERENCES app(id) ON DELETE CASCADE
);

INSERT INTO entity_type_app_mapping(entity_type, app_id)
    SELECT 'NETWORK', 'news' WHERE EXISTS (
        SELECT * FROM customer_category WHERE customertype='standard');
INSERT INTO entity_type_app_mapping(entity_type, app_id)
    SELECT 'GROUP', 'news' WHERE EXISTS (
        SELECT * FROM customer_category WHERE customertype='standard');
INSERT INTO entity_type_app_mapping(entity_type, app_id)
    SELECT 'APPOINTMENT', 'news' WHERE EXISTS (
        SELECT * FROM customer_category WHERE customertype='standard');
COMMIT;
