BEGIN;

CREATE TABLE sh_tasks (
    id uuid,
    name VARCHAR(2048),
    description text,
    owner_id bigint,
    assignee_id bigint,
    status VARCHAR(255),
    create_date timestamp,
    modify_date timestamp,
    parent_task_id uuid,
    delete_action_id bigint,

    CONSTRAINT sh_tasks_delete_action_id_fk FOREIGN KEY (delete_action_id) REFERENCES delete_action (id)
);

UPDATE tasks SET deleted = 't' WHERE parent_task_id IN (SELECT id FROM tasks WHERE deleted = 't');

INSERT INTO sh_tasks(id, name, description, owner_id, assignee_id, status, create_date, modify_date, parent_task_id)
SELECT               id, name, description, owner_id, assignee_id, status, create_date, modify_date, parent_task_id
FROM tasks
WHERE deleted = 't';

DELETE FROM tasks
WHERE deleted = 't';

ALTER TABLE tasks
DROP COLUMN deleted;

INSERT INTO shadow_table (table_name,shadow_table_name,delete_action_mandatory)
VALUES ('tasks','sh_tasks','f');

COMMIT;