BEGIN;

CREATE SEQUENCE profile_attribute_seq;

CREATE TABLE profile_attribute (
    id bigint NOT NULL,
    person_id bigint NOT NULL,
    name varchar(255) NOT NULL,
    value text NOT NULL,
    value_order integer NOT NULL,
    section_order integer NOT NULL,
    create_date timestamp NOT NULL DEFAULT now(),
    CONSTRAINT profile_attribute_pk PRIMARY KEY (id),
    CONSTRAINT profile_attribute_person_id_fk FOREIGN KEY (person_id) REFERENCES person (id)
);

CREATE TABLE sh_profile_attribute (
    id bigint,
    person_id bigint,
    name varchar(255),
    value text,
    value_order integer,
    section_order integer,
    delete_action_id bigint,
    create_date timestamp,
    CONSTRAINT sh_profile_attribute_delete_action_id_fk FOREIGN KEY (delete_action_id) REFERENCES delete_action (id)
);


INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('profile_attribute','sh_profile_attribute','f');

COMMIT;