BEGIN;

-- remove table with different pk
DROP TABLE push_notification_device;

CREATE SEQUENCE push_notification_device_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;

-- recreate tabel with new pk
CREATE TABLE push_notification_device (
    id bigint NOT NULL,
    device_id varchar(256) NOT NULL,
    protocol varchar(100) NOT NULL,
    person_id bigint NOT NULL,
    create_at timestamp DEFAULT now(),
    modify_at timestamp DEFAULT now(),
    CONSTRAINT p_n_device_pk PRIMARY KEY (id),
    CONSTRAINT p_n_device_uq UNIQUE (device_id, protocol),
    CONSTRAINT p_n_device_person_fk FOREIGN KEY (person_id) REFERENCES person(id) ON DELETE CASCADE
);

-- access by person id is very common. make it faster:
CREATE INDEX p_n_device_person_idx ON push_notification_device(person_id);

COMMIT;
