BEGIN;

-- insert renamed workflow roles
INSERT INTO entity_member_role_name ( name ) VALUES ( 'EVENT_IS_ATTENDING'           );
INSERT INTO entity_member_role_name ( name ) VALUES ( 'EVENT_IS_NOT_ATTENDING'       );
INSERT INTO entity_member_role_name ( name ) VALUES ( 'EVENT_IS_MAYBE_ATTENDING'     );
INSERT INTO entity_member_role_name ( name ) VALUES ( 'EVENT_IS_ON_WAITINGLIST'      );
INSERT INTO entity_member_role_name ( name ) VALUES ( 'EVENT_HAS_REJECTED_INVITATION');

-- rename existing roles
UPDATE entity_member_role
SET   role = 'EVENT_IS_ATTENDING'
WHERE role = 'EVENT_ATTEND';

UPDATE entity_member_role
SET   role = 'EVENT_IS_NOT_ATTENDING'
WHERE role = 'EVENT_DONT_ATTEND';

UPDATE entity_member_role
SET   role = 'EVENT_IS_MAYBE_ATTENDING'
WHERE role = 'EVENT_MAYBE_ATTEND';

UPDATE entity_member_role
SET   role = 'EVENT_IS_ON_WAITINGLIST'
WHERE role = 'EVENT_ON_WAITINGLIST';

UPDATE entity_member_role
SET   role = 'EVENT_HAS_REJECTED_INVITATION'
WHERE role = 'EVENT_REJECTED_INVITATION';

-- drop old names
DELETE FROM entity_member_role_name
WHERE name in (
    'EVENT_ATTEND',
    'EVENT_DONT_ATTEND',
    'EVENT_MAYBE_ATTEND',
    'EVENT_ON_WAITINGLIST',
    'EVENT_REJECTED_INVITATION'
);

-- done
COMMIT;
