BEGIN;

CREATE SEQUENCE theme_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NO MAXVALUE
    CACHE 1;

    
    
CREATE TABLE theme (
    id BIGINT NOT NULL,
    name VARCHAR NULL,
    shared char(1) DEFAULT ('f') NOT NULL,
    default_theme char(1) DEFAULT ('f') NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    modify_date timestamp without time zone DEFAULT now(),
    CONSTRAINT theme_pk PRIMARY KEY (id)
);


CREATE TABLE theme_attribute (
   theme_id BIGINT NOT NULL,
   entity_type VARCHAR NULL,
   attribute_type VARCHAR NOT NULL,
   attribute_value VARCHAR NULL,
   CONSTRAINT theme_element_pkey UNIQUE(theme_id, entity_type, attribute_type),
   CONSTRAINT theme_element_theme_fk FOREIGN KEY (theme_id) REFERENCES theme(id) ON DELETE CASCADE,
   CONSTRAINT theme_velement_type_fk FOREIGN KEY (entity_type) REFERENCES entity_type_name(name) ON DELETE CASCADE
);


CREATE TABLE entity_theme (
    theme_id BIGINT NOT NULL,
    entity_id BIGINT NOT NULL,
    CONSTRAINT entity_theme_pk PRIMARY KEY (entity_id),
    CONSTRAINT entity_theme_theme_fk FOREIGN KEY (theme_id) REFERENCES theme(id) ON DELETE CASCADE,
    CONSTRAINT entity_theme_entity_id_fk FOREIGN KEY (entity_id) REFERENCES entity(id) ON DELETE CASCADE
);

COMMIT;
