BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00003, '7.4', '00003_#patch_drop_activation_hash.sql', 'BUGFIX', '#6660 Spalte activation_hash aus Person entfernen', now());

CREATE OR REPLACE FUNCTION DROPCOLUMN(tblSchema VARCHAR, tblName VARCHAR, colName VARCHAR) RETURNS void AS $$
DECLARE
     execString TEXT;
BEGIN
     execString := 'ALTER TABLE ';
     IF tblSchema != NULL THEN
         execString := execString || quote_ident(tblSchema) || '.';
     END IF;
     execString := execString || quote_ident(tblName) || ' DROP COLUMN ' || quote_ident(colName);
     EXECUTE execString;
EXCEPTION
     WHEN OTHERS THEN
         NULL;
END;
$$ LANGUAGE plpgsql;

SELECT DROPCOLUMN(null, 'person', 'activation_hash');
ALTER TABLE sh_person DROP COLUMN activation_hash;

DROP FUNCTION DROPCOLUMN(tblSchema VARCHAR, tblName VARCHAR, colName VARCHAR);

COMMIT;
