BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01294, '6.11', 'migrate_entity_type_name', 'FEATURE', 'creates a new table to sync entity type names', now());

CREATE OR REPLACE FUNCTION drop_contraint_if_exists (t_name text, c_name text) RETURNS VOID AS
$$
BEGIN
    IF EXISTS (SELECT constraint_name FROM information_schema.constraint_column_usage WHERE table_name = t_name  AND constraint_name = c_name) THEN
        EXECUTE 'ALTER TABLE ' || quote_ident(t_name) || ' DROP CONSTRAINT ' || quote_ident(c_name) || ';';
    END IF;
END;
$$ LANGUAGE plpgsql;

-- create and fill new table entity_type_name
CREATE TABLE entity_type_name (
    name VARCHAR(255) NOT NULL PRIMARY KEY,
    old_id bigint NOT NULL
);

INSERT INTO entity_type_name VALUES
    ('NETWORK', 0),
    ('GROUP', 1),
    ('WIKI', 2),
    ('APPOINTMENT', 3),
    ('PUBLICATION', 4),
    ('TOPIC', 5),
    ('PARTNERSITE',6),
    ('ARTICLE', 7);

-- migrate entity_category
SELECT drop_contraint_if_exists('entity_category','entity_category_entity_type_fkey');
SELECT drop_contraint_if_exists('entity_category','entity_category_pkey');

ALTER TABLE entity_category RENAME COLUMN entity_type TO old_entity_type;
ALTER TABLE entity_category ADD COLUMN entity_type VARCHAR(255);

UPDATE entity_category SET entity_type = (SELECT name FROM entity_type_name etn WHERE old_id = old_entity_type);
ALTER TABLE entity_category DROP COLUMN old_entity_type;
ALTER TABLE entity_category ALTER COLUMN entity_type SET NOT NULL;
ALTER TABLE entity_category ADD PRIMARY KEY (entity_type, category);
ALTER TABLE entity_category ADD CONSTRAINT entity_category_entity_type_name_fkey FOREIGN KEY (entity_type) REFERENCES entity_type_name(name);

-- migrate entity
SELECT drop_contraint_if_exists('entity','entity_entity_type_fkey');

ALTER TABLE entity RENAME COLUMN entity_type TO old_entity_type;
ALTER TABLE entity ADD COLUMN entity_type VARCHAR(255);

UPDATE entity SET entity_type = (SELECT name FROM entity_type_name etn WHERE old_id = old_entity_type);
ALTER TABLE entity DROP COLUMN old_entity_type;
ALTER TABLE entity ALTER COLUMN entity_type SET NOT NULL;
ALTER TABLE entity ADD CONSTRAINT entity_entity_type_name_fkey FOREIGN KEY (entity_type) REFERENCES entity_type_name(name);

CREATE INDEX idx_entity_entity_type ON entity(entity_type);

-- migrate entity_linked_entity_type_privacy
ALTER TABLE entity_linked_entity_type_privacy ALTER COLUMN entity_type TYPE VARCHAR(255);
ALTER TABLE entity_linked_entity_type_privacy ADD CONSTRAINT entity_linked_entity_type_privacy_entity_type_name_fkey FOREIGN KEY (entity_type) REFERENCES entity_type_name(name);

-- remove column old_id, it was used for migration only
ALTER TABLE entity_type_name DROP COLUMN old_id;

COMMIT;
