BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01177, '5.11', 'create_user_settings', 'FEATURE', 'Generic key-value-store for user specific settings. See src/services/java/de/justsoftware/onx/person/shared/model/settings/SettingType.java.', now());

CREATE SEQUENCE user_settings_seq MINVALUE 0 START 0;

CREATE TABLE user_settings (
    id bigint NOT NULL PRIMARY KEY DEFAULT nextval('user_settings_seq'),
    person_id numeric(10) NOT NULL,
    key varchar(30) NOT NULL,
    value varchar NOT NULL,
    create_date timestamp without time zone DEFAULT now(),
    modify_date timestamp without time zone DEFAULT now(),
    FOREIGN KEY ( person_id ) REFERENCES person ( person_id ) ON DELETE CASCADE
);

CREATE UNIQUE INDEX idx_personid_key ON user_settings (person_id, key);

COMMIT;

