/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.dbmaintain.util.DbMaintainException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static <T> T createInstanceOfType(String className, boolean bypassAccessibility) {
        return ReflectionUtils.createInstanceOfType(className, bypassAccessibility, new Class[0], new Object[0]);
    }

    private static <T> T createInstanceOfType(String className, boolean bypassAccessibility, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            Class<?> type = Class.forName(className);
            return (T)ReflectionUtils.createInstanceOfType(type, bypassAccessibility, parameterTypes, parameters);
        }
        catch (ClassCastException e) {
            throw new DbMaintainException("Class " + className + " is not of expected type.", e);
        }
        catch (NoClassDefFoundError e) {
            throw new DbMaintainException("Unable to load class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new DbMaintainException("Class " + className + " not found", e);
        }
        catch (DbMaintainException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DbMaintainException("Error while instantiating class " + className, e);
        }
    }

    public static <T> T createInstanceOfType(Class<T> type, boolean bypassAccessibility, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(parameterTypes);
            if (bypassAccessibility) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DbMaintainException) {
                throw (DbMaintainException)cause;
            }
            throw new DbMaintainException("Error while trying to create object of class " + type.getName(), cause);
        }
        catch (Exception e) {
            throw new DbMaintainException("Error while trying to create object of class " + type.getName(), e);
        }
    }

    public static <T> Class<T> getClassWithName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable t) {
            throw new DbMaintainException("Could not load class with name " + className, t);
        }
    }
}

