/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.ScriptContentHandle;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.qualifier.Qualifier;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.lang.StringUtils;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFactory {
    private static Log logger = LogFactory.getLog(ScriptFactory.class);
    private Pattern scriptIndexPattern;
    private Pattern targetDatabasePattern;
    private Pattern qualifierPattern;
    private Set<Qualifier> registeredQualifiers;
    private Set<Qualifier> patchQualifiers;
    private String postProcessingScriptDirName;
    protected ScriptIndexes baseLineRevision;

    public ScriptFactory(String scriptIndexRegexp, String targetDatabaseRegexp, String qualifierRegexp, Set<Qualifier> registeredQualifiers, Set<Qualifier> patchQualifiers, String postProcessingScriptDirName, ScriptIndexes baseLineRevision) {
        this.registeredQualifiers = registeredQualifiers;
        this.patchQualifiers = patchQualifiers;
        this.postProcessingScriptDirName = postProcessingScriptDirName;
        this.baseLineRevision = baseLineRevision;
        this.scriptIndexPattern = Pattern.compile(scriptIndexRegexp);
        this.targetDatabasePattern = Pattern.compile(targetDatabaseRegexp);
        this.qualifierPattern = Pattern.compile(qualifierRegexp);
        if (baseLineRevision != null) {
            logger.info("The baseline revision is set to " + baseLineRevision.getIndexesString() + ". All script with a lower revision will be ignored");
        }
    }

    public Script createScriptWithContent(String fileName, Long fileLastModifiedAt, ScriptContentHandle scriptContentHandle) {
        return this.createScript(fileName, fileLastModifiedAt, null, scriptContentHandle);
    }

    public Script createScriptWithoutContent(String fileName, Long fileLastModifiedAt, String checkSum) {
        return this.createScript(fileName, fileLastModifiedAt, checkSum, null);
    }

    private Script createScript(String fileName, Long fileLastModifiedAt, String checkSum, ScriptContentHandle scriptContentHandle) {
        try {
            String[] pathParts = this.getPathParts(fileName);
            ScriptIndexes scriptIndexes = this.getScriptIndexes(pathParts);
            String targetDatabaseName = this.getTargetDatabaseName(pathParts);
            Set<Qualifier> qualifiers = this.getQualifiers(pathParts);
            boolean patchScript = this.isPatchScript(qualifiers);
            boolean postProcessingScript = this.isPostProcessingScript(fileName);
            boolean ignored = this.isIgnored(scriptIndexes);
            return new Script(fileName, scriptIndexes, targetDatabaseName, fileLastModifiedAt, checkSum, scriptContentHandle, postProcessingScript, patchScript, ignored, qualifiers);
        }
        catch (DbMaintainException e) {
            throw new DbMaintainException("Error in script " + fileName + ": " + e.getMessage(), e);
        }
    }

    protected boolean isPostProcessingScript(String fileName) {
        if (StringUtils.isEmpty(this.postProcessingScriptDirName)) {
            return false;
        }
        String dirName = this.postProcessingScriptDirName;
        if (this.postProcessingScriptDirName.endsWith("/") || this.postProcessingScriptDirName.endsWith("\\")) {
            dirName = this.postProcessingScriptDirName.substring(0, this.postProcessingScriptDirName.length() - 1);
        }
        return fileName.startsWith(dirName + '/') || fileName.startsWith(dirName + '\\');
    }

    protected String getTargetDatabaseName(String[] pathParts) {
        List<String> databaseNames = this.getTokens(pathParts, this.targetDatabasePattern, false);
        if (databaseNames.isEmpty()) {
            return null;
        }
        return databaseNames.get(databaseNames.size() - 1);
    }

    protected Set<Qualifier> getQualifiers(String[] pathParts) {
        HashSet<Qualifier> qualifiers = new HashSet<Qualifier>();
        List<String> qualifierNames = this.getTokens(pathParts, this.qualifierPattern, false);
        for (String qualifierName : qualifierNames) {
            Qualifier qualifier = new Qualifier(qualifierName);
            if (!this.registeredQualifiers.contains(qualifier) && !this.patchQualifiers.contains(qualifier)) {
                throw new DbMaintainException("Qualifier \"" + qualifier.getQualifierName() + "\" has not been registered.");
            }
            qualifiers.add(qualifier);
        }
        return qualifiers;
    }

    protected ScriptIndexes getScriptIndexes(String[] pathParts) {
        ArrayList<Long> versionIndexes = new ArrayList<Long>();
        List<String> versionIndexStrings = this.getTokens(pathParts, this.scriptIndexPattern, true);
        for (String versionIndexString : versionIndexStrings) {
            if (versionIndexString == null) {
                versionIndexes.add(null);
                continue;
            }
            try {
                versionIndexes.add(new Long(versionIndexString));
            }
            catch (NumberFormatException e) {
                throw new DbMaintainException("Unable to parse version index: " + versionIndexString, e);
            }
        }
        return new ScriptIndexes(versionIndexes);
    }

    protected List<String> getTokens(String[] pathParts, Pattern pattern, boolean addNullIfNoMatch) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (String pathPart : pathParts) {
            Matcher matcher = pattern.matcher(pathPart);
            boolean foundMatch = matcher.find();
            if (!foundMatch) {
                if (!addNullIfNoMatch) continue;
                tokens.add(null);
                continue;
            }
            while (foundMatch) {
                String qualifierName = matcher.group(1);
                tokens.add(qualifierName);
                foundMatch = matcher.find();
            }
        }
        return tokens;
    }

    protected String[] getPathParts(String fileName) {
        String fileNameWithoutExtension = StringUtils.substringBeforeLast(fileName, ".");
        String fileNameWithForwardSlashes = fileNameWithoutExtension.replace('\\', '/');
        return StringUtils.split(fileNameWithForwardSlashes, '/');
    }

    protected boolean isIgnored(ScriptIndexes scriptIndexes) {
        return this.baseLineRevision != null && this.baseLineRevision.compareTo(scriptIndexes) > 0;
    }

    public boolean isPatchScript(Set<Qualifier> qualifiers) {
        for (Qualifier qualifier : qualifiers) {
            if (!this.patchQualifiers.contains(qualifier)) continue;
            return true;
        }
        return false;
    }
}

