/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.IdentifierProcessor;
import thirdparty.org.apache.commons.dbutils.DbUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformixDatabase
extends Database {
    public InformixDatabase(DatabaseConnection databaseConnection, IdentifierProcessor identifierProcessor) {
        super(databaseConnection, identifierProcessor);
    }

    @Override
    public String getSupportedDatabaseDialect() {
        return "informix";
    }

    @Override
    public Set<String> getTableNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select tabname from systables where owner = '" + schemaName + "' and tabid > 99 and tabtype = 'T'", this.getDataSource());
    }

    @Override
    public Set<String> getColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select sc.colname from syscolumns sc join systables st on sc.tabid = st.tabid and st.tabname = '" + tableName + "' and st.owner = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getViewNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select tabname from systables where owner = '" + schemaName + "' and tabid > 99 and tabtype = 'V'", this.getDataSource());
    }

    @Override
    public void disableReferentialConstraints(String schemaName) {
        this.disableConstraints(schemaName, "R");
    }

    @Override
    public void disableValueConstraints(String schemaName) {
        this.disableConstraints(schemaName, "N");
    }

    protected void disableConstraints(String schemaName, String constraintType) {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("SELECT SC.CONSTRNAME CONSTRAINTNAME FROM SYSCONSTRAINTS SC JOIN SYSTABLES ST ON SC.TABID = ST.TABID WHERE ST.OWNER='" + schemaName + "' AND SC.CONSTRTYPE='" + constraintType + "'");
            while (resultSet.next()) {
                String constraintName = resultSet.getString("CONSTRAINTNAME");
                alterStatement.executeUpdate("SET CONSTRAINTS " + this.quoted(constraintName) + " DISABLED");
            }
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to disable value constraints for schema name: " + schemaName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }
}

