/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.dbmaintain.config.PropertyUtils;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.IdentifierProcessor;
import org.dbmaintain.database.StoredIdentifierCase;
import thirdparty.org.apache.commons.dbutils.DbUtils;
import thirdparty.org.apache.commons.lang.StringUtils;

public class IdentifierProcessorFactory {
    protected Properties configuration;

    public IdentifierProcessorFactory(Properties configuration) {
        this.configuration = configuration;
    }

    public IdentifierProcessor createIdentifierProcessor(String databaseDialect, String defaultSchemaName, DataSource dataSource) {
        String customIdentifierQuoteString = this.getCustomIdentifierQuoteString(databaseDialect, this.configuration);
        StoredIdentifierCase customStoredIdentifierCase = this.getCustomStoredIdentifierCase(databaseDialect, this.configuration);
        StoredIdentifierCase storedIdentifierCase = this.determineStoredIdentifierCase(customStoredIdentifierCase, dataSource);
        String identifierQuoteString = this.determineIdentifierQuoteString(customIdentifierQuoteString, dataSource);
        return new IdentifierProcessor(storedIdentifierCase, identifierQuoteString, defaultSchemaName);
    }

    protected StoredIdentifierCase determineStoredIdentifierCase(StoredIdentifierCase customStoredIdentifierCase, DataSource dataSource) {
        if (customStoredIdentifierCase != null) {
            return customStoredIdentifierCase;
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData.storesUpperCaseIdentifiers()) {
                StoredIdentifierCase storedIdentifierCase = StoredIdentifierCase.UPPER_CASE;
                return storedIdentifierCase;
            }
            if (databaseMetaData.storesLowerCaseIdentifiers()) {
                StoredIdentifierCase storedIdentifierCase = StoredIdentifierCase.LOWER_CASE;
                return storedIdentifierCase;
            }
            StoredIdentifierCase storedIdentifierCase = StoredIdentifierCase.MIXED_CASE;
            return storedIdentifierCase;
        }
        catch (SQLException e) {
            throw new DatabaseException("Unable to determine stored identifier case.", e);
        }
        finally {
            DbUtils.closeQuietly(connection, null, null);
        }
    }

    protected String determineIdentifierQuoteString(String customIdentifierQuoteString, DataSource dataSource) {
        if (customIdentifierQuoteString != null) {
            return StringUtils.trimToNull(customIdentifierQuoteString);
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String quoteString = databaseMetaData.getIdentifierQuoteString();
            String string = StringUtils.trimToNull(quoteString);
            return string;
        }
        catch (SQLException e) {
            throw new DatabaseException("Unable to determine identifier quote string.", e);
        }
        finally {
            DbUtils.closeQuietly(connection, null, null);
        }
    }

    protected StoredIdentifierCase getCustomStoredIdentifierCase(String databaseDialect, Properties configuration) {
        String storedIdentifierCasePropertyValue = PropertyUtils.getString("database.storedIndentifierCase." + databaseDialect, "auto", configuration);
        if ("lower_case".equals(storedIdentifierCasePropertyValue)) {
            return StoredIdentifierCase.LOWER_CASE;
        }
        if ("upper_case".equals(storedIdentifierCasePropertyValue)) {
            return StoredIdentifierCase.UPPER_CASE;
        }
        if ("mixed_case".equals(storedIdentifierCasePropertyValue)) {
            return StoredIdentifierCase.MIXED_CASE;
        }
        if ("auto".equals(storedIdentifierCasePropertyValue)) {
            return null;
        }
        throw new DatabaseException("Unable to determine stored identifier case. Unknown value " + storedIdentifierCasePropertyValue + " for property " + "database.storedIndentifierCase" + ". It should be one of lower_case, upper_case, mixed_case or auto.");
    }

    protected String getCustomIdentifierQuoteString(String databaseDialect, Properties configuration) {
        String identifierQuoteStringPropertyValue = PropertyUtils.getString("database.identifierQuoteString." + databaseDialect, "auto", configuration);
        if ("none".equals(identifierQuoteStringPropertyValue)) {
            return "";
        }
        if ("auto".equals(identifierQuoteStringPropertyValue)) {
            return null;
        }
        return identifierQuoteStringPropertyValue;
    }
}

