/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.ReflectionUtils;
import thirdparty.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtils {
    public static String getString(String propertyName, Properties properties) {
        String value = PropertyUtils.getProperty(propertyName, properties);
        if (value == null || "".equals(value.trim())) {
            throw new DbMaintainException("No value found for property " + propertyName);
        }
        return value.trim();
    }

    public static String getString(String propertyName, String defaultValue, Properties properties) {
        String value = PropertyUtils.getProperty(propertyName, properties);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return value.trim();
    }

    public static List<String> getStringList(String propertyName, Properties properties) {
        return PropertyUtils.getStringList(propertyName, properties, false);
    }

    public static List<String> getStringList(String propertyName, Properties properties, boolean required) {
        String values = PropertyUtils.getProperty(propertyName, properties);
        if (values == null || "".equals(values.trim())) {
            if (required) {
                throw new DbMaintainException("No value found for property " + propertyName);
            }
            return new ArrayList<String>(0);
        }
        String[] splitValues = StringUtils.split(values, ",");
        ArrayList<String> result = new ArrayList<String>(splitValues.length);
        for (String value : splitValues) {
            result.add(value.trim());
        }
        if (required && result.isEmpty()) {
            throw new DbMaintainException("No value found for property " + propertyName);
        }
        return result;
    }

    public static boolean getBoolean(String propertyName, Properties properties) {
        String value = PropertyUtils.getProperty(propertyName, properties);
        if (value == null || "".equals(value.trim())) {
            throw new DbMaintainException("No value found for property " + propertyName);
        }
        return Boolean.valueOf(value.trim());
    }

    public static boolean getBoolean(String propertyName, boolean defaultValue, Properties properties) {
        String value = PropertyUtils.getProperty(propertyName, properties);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return Boolean.valueOf(value.trim());
    }

    public static long getLong(String propertyName, Properties properties) {
        String value = PropertyUtils.getProperty(propertyName, properties);
        if (value == null || "".equals(value.trim())) {
            throw new DbMaintainException("No value found for property " + propertyName);
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new DbMaintainException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public static long getLong(String propertyName, long defaultValue, Properties properties) {
        String value = PropertyUtils.getProperty(propertyName, properties);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new DbMaintainException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public static int getInt(String propertyName, Properties properties) {
        String value = PropertyUtils.getProperty(propertyName, properties);
        if (value == null || "".equals(value.trim())) {
            throw new DbMaintainException("No value found for property " + propertyName);
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new DbMaintainException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public static int getInt(String propertyName, int defaultValue, Properties properties) {
        String value = PropertyUtils.getProperty(propertyName, properties);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new DbMaintainException("Value " + value + " for property " + propertyName + " is not a number.");
        }
    }

    public static boolean containsProperty(String propertyName, Properties properties) {
        return PropertyUtils.getProperty(propertyName, properties) != null;
    }

    public static <T> T getInstance(String propertyName, Properties properties) {
        String className = PropertyUtils.getString(propertyName, properties);
        return ReflectionUtils.createInstanceOfType(className, false);
    }

    public static <T> T getInstance(String propertyName, T defaultValue, Properties properties) {
        String className = PropertyUtils.getString(propertyName, null, properties);
        if (className == null) {
            return defaultValue;
        }
        return ReflectionUtils.createInstanceOfType(className, false);
    }

    public static String getProperty(String propertyName, Properties properties) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            value = properties.getProperty(propertyName);
        }
        return value;
    }
}

