-- state is bad as 2nd key
DROP INDEX subs_sid_state_iid_idx;
CREATE UNIQUE INDEX subs_sid_iid_state_idx ON subscriptions(subscriber_id, item_id, subscription_state);

-- current index doesn't contain entity_id, with entity_id it is unique, the reveresed PK
DROP INDEX entity_parents_parent_idx;
CREATE UNIQUE INDEX entity_parents_parent_idx ON entity_parents(parent_id,entity_id);

-- currently item_visibility_role_idx is used but inperformant, the new index is accessed by the roles which are constant parameters
DROP INDEX itm_vis_role_role_idx;
CREATE INDEX itm_vis_role_role_idx ON item_visibility_role(role_name, item_id, origin_type);
-- origin type index is not used
DROP INDEX itm_vis_role_otype_idx;
-- old index, replaced by single column index for creation and deletion
DROP INDEX item_visibility_role_idx;
CREATE INDEX itm_vis_role_iid_idx ON item_visibility_role(item_id);

-- add type and origin_item_id to author index to get subscripitons visibility and type filter connected
DROP INDEX workstream_entry_author_idx;
CREATE INDEX workstream_entry_author_idx ON workstream_entry(author_id, type, origin_item_id);

-- add type to origin_item_id index to get subscripitons visibility and type filter connected
DROP INDEX we_orig_item_idx;
CREATE INDEX we_orig_item_idx ON workstream_entry(origin_item_id, type);

-- add type and origin_item_id to subject index to get subscripitons visibility and type filter connected
DROP INDEX workstream_entry_subject_idx;
CREATE INDEX workstream_entry_subject_idx ON workstream_entry(subject_item_id, type, origin_item_id);

COMMIT;
