CREATE SEQUENCE conversation_search_queue_seq
    MINVALUE 0
    START WITH 0
    INCREMENT BY 1
    NOCACHE;

CREATE TABLE conversation_search_queue (
    id NUMBER(19, 0) NOT NULL,
    item_id NUMBER(19, 0) NOT NULL,
    item_type VARCHAR2(32 char) NOT NULL,
    conversation_index_type VARCHAR2(32 char) NOT NULL,
    created_at TIMESTAMP DEFAULT systimestamp NOT NULL,
    modified_at TIMESTAMP DEFAULT systimestamp NOT NULL,
    in_progress CHAR(1) DEFAULT 'f' NOT NULL,
    lock_id NUMBER(19, 0),
    CONSTRAINT cnv_srch_q_pk PRIMARY KEY (id)
);

CREATE INDEX cnv_srch_q_itm_idx_ip_ca_idx ON conversation_search_queue (item_id, item_type, in_progress, created_at ASC);
CREATE INDEX cnv_srch_q_id_lc_ip_idx ON conversation_search_queue (id, lock_id, in_progress);
CREATE INDEX cnv_srch_q_mod_idx ON conversation_search_queue (modified_at);
CREATE INDEX cnv_srch_q_crt_idx ON conversation_search_queue (created_at ASC);
CREATE INDEX cnv_srch_q_ip_mod_idx ON conversation_search_queue (in_progress, modified_at);


COMMIT;