-- add pk to oauth_refresh_token
ALTER TABLE oauth_refresh_token ADD CONSTRAINT oauth_refresh_token_pk PRIMARY KEY (token_id);
-- add pk to the oauth_access_token to other oauth tables
ALTER TABLE oauth_access_token  ADD CONSTRAINT oauth_access_token_pk  PRIMARY KEY (token_id);
-- add indice for common selects within the JdbcTokenStore
CREATE INDEX idx_oauth_access_token_auth    ON oauth_access_token (authentication_id);
CREATE INDEX idx_oauth_access_token_refresh ON oauth_access_token (refresh_token);
CREATE INDEX idx_oauth_access_token_user    ON oauth_access_token (client_id, user_name);

-- drop unused tables

-- This table would be used by the JdbcClientTokenServices, which in turn is used by the OAuth2RestTemplate, which is used by clients, so not us as server.
-- If we are at some point client to another OAuth-Service, then we could use it or write our own store....
DROP TABLE oauth_client_token;
-- This table would be used by the JdbcAuthorizationCodeServices, which we don't use. We use the InMemoryAuthorizationCodeServices.
DROP TABLE oauth_code;
-- This table would be used by the JdbcApprovalStore, which we don't use. We use the TokenApprovalStore.
DROP TABLE oauth_approvals;

COMMIT;
